/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.quest.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.quest.Gs2QuestRestClient;
import io.gs2.quest.domain.model.NamespaceDomain;
import io.gs2.quest.domain.model.QuestGroupModelMasterDomain;
import io.gs2.quest.model.QuestGroupModelMaster;
import io.gs2.quest.request.DescribeQuestGroupModelMastersRequest;
import io.gs2.quest.result.DescribeQuestGroupModelMastersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeQuestGroupModelMastersIterator
implements Iterator<QuestGroupModelMaster>,
Iterable<QuestGroupModelMaster> {
    CacheDatabase cache;
    Gs2QuestRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<QuestGroupModelMaster> result;
    Integer fetchSize;

    public DescribeQuestGroupModelMastersIterator(CacheDatabase cache, Gs2QuestRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<QuestGroupModelMaster>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "QuestGroupModelMaster");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, QuestGroupModelMaster.class)) {
            this.result = this.cache.list(parentKey, QuestGroupModelMaster.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeQuestGroupModelMastersResult r = this.client.describeQuestGroupModelMasters(new DescribeQuestGroupModelMastersRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (QuestGroupModelMaster item : this.result) {
                this.cache.put(parentKey, QuestGroupModelMasterDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, QuestGroupModelMaster.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public QuestGroupModelMaster next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        QuestGroupModelMaster ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<QuestGroupModelMaster> iterator() {
        return this;
    }
}

