/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.quest.domain;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.jobQueue.model.Job;
import io.gs2.jobQueue.model.JobResultBody;
import io.gs2.quest.Gs2QuestRestClient;
import io.gs2.quest.domain.iterator.DescribeNamespacesIterator;
import io.gs2.quest.domain.model.NamespaceDomain;
import io.gs2.quest.domain.model.ProgressDomain;
import io.gs2.quest.domain.model.UserDomain;
import io.gs2.quest.model.Progress;
import io.gs2.quest.request.CreateNamespaceRequest;
import io.gs2.quest.request.CreateProgressByUserIdRequest;
import io.gs2.quest.request.DeleteProgressByUserIdRequest;
import io.gs2.quest.result.CreateNamespaceResult;
import io.gs2.quest.result.CreateProgressByUserIdResult;
import io.gs2.quest.result.DeleteProgressByUserIdResult;

public class Gs2Quest {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2QuestRestClient client;
    private final String parentKey;

    public Gs2Quest(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2QuestRestClient(session);
        this.parentKey = "quest";
    }

    public NamespaceDomain createNamespace(CreateNamespaceRequest request) {
        CreateNamespaceResult result = this.client.createNamespace(request);
        String parentKey = "quest:Namespace";
        if (result.getItem() != null) {
            this.cache.put(parentKey, NamespaceDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        NamespaceDomain domain = new NamespaceDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, result.getItem().getName());
        return domain;
    }

    public DescribeNamespacesIterator namespaces() {
        return new DescribeNamespacesIterator(this.cache, this.client);
    }

    public NamespaceDomain namespace(String namespaceName) {
        return new NamespaceDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, namespaceName);
    }

    public static void updateCacheFromStampSheet(CacheDatabase cache, String method, String request, String result) {
        try {
            switch (method) {
                case "CreateProgressByUserId": {
                    CreateProgressByUserIdRequest requestModel = CreateProgressByUserIdRequest.fromJson(new ObjectMapper().readTree(request));
                    CreateProgressByUserIdResult resultModel = CreateProgressByUserIdResult.fromJson(new ObjectMapper().readTree(result));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Progress");
                    String key = ProgressDomain.createCacheKey();
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static void updateCacheFromStampTask(CacheDatabase cache, String method, String request, String result) {
        try {
            switch (method) {
                case "DeleteProgressByUserId": {
                    DeleteProgressByUserIdRequest requestModel = DeleteProgressByUserIdRequest.fromJson(new ObjectMapper().readTree(request));
                    DeleteProgressByUserIdResult resultModel = DeleteProgressByUserIdResult.fromJson(new ObjectMapper().readTree(result));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Progress");
                    String key = ProgressDomain.createCacheKey();
                    cache.delete(parentKey, key, Progress.class);
                    break;
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static void updateCacheFromJobResult(CacheDatabase cache, String method, Job job, JobResultBody result) {
        try {
            switch (method) {
                case "create_progress_by_user_id": {
                    CreateProgressByUserIdRequest requestModel = CreateProgressByUserIdRequest.fromJson(new ObjectMapper().readTree(job.getArgs()));
                    CreateProgressByUserIdResult resultModel = CreateProgressByUserIdResult.fromJson(new ObjectMapper().readTree(result.getResult()));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Progress");
                    String key = ProgressDomain.createCacheKey();
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }
}

