/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.news.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.news.Gs2NewsRestClient;
import io.gs2.news.domain.iterator.DescribeNewsIterator;
import io.gs2.news.domain.model.NamespaceDomain;
import io.gs2.news.domain.model.NewsAccessTokenDomain;
import io.gs2.news.domain.model.SetCookieRequestEntryAccessTokenDomain;

public class UserAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2NewsRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String parentKey;
    String contentHash;
    String templateHash;

    public String getContentHash() {
        return this.contentHash;
    }

    public String getTemplateHash() {
        return this.templateHash;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public UserAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2NewsRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "User");
    }

    public DescribeNewsIterator newses() {
        return new DescribeNewsIterator(this.cache, this.client, this.namespaceName, this.accessToken);
    }

    public NewsAccessTokenDomain news() {
        return new NewsAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken);
    }

    public SetCookieRequestEntryAccessTokenDomain setCookieRequestEntry(String key, String value) {
        return new SetCookieRequestEntryAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken, key, value);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "news", namespaceName, userId, childType);
    }

    public static String createCacheKey(String userId) {
        return String.join((CharSequence)":", userId);
    }
}

