/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.news.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.news.Gs2NewsRestClient;
import io.gs2.news.domain.model.UserDomain;
import io.gs2.news.model.SetCookieRequestEntry;

public class SetCookieRequestEntryDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2NewsRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String key;
    private final String value;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public SetCookieRequestEntryDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String key, String value) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2NewsRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.key = key;
        this.value = value;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "SetCookieRequestEntry");
    }

    public static String createCacheParentKey(String namespaceName, String userId, String key, String value, String childType) {
        return String.join((CharSequence)":", "news", namespaceName, userId, key, value, childType);
    }

    public static String createCacheKey(String key, String value) {
        return String.join((CharSequence)":", key, value);
    }

    public SetCookieRequestEntry model() {
        SetCookieRequestEntry value = this.cache.get(this.parentKey, SetCookieRequestEntryDomain.createCacheKey(this.getKey() != null ? this.getKey().toString() : null, this.getValue() != null ? this.getValue().toString() : null), SetCookieRequestEntry.class);
        return value;
    }
}

