/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.news.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.news.Gs2NewsRestClient;
import io.gs2.news.domain.model.SetCookieRequestEntryDomain;
import io.gs2.news.domain.model.UserDomain;
import io.gs2.news.model.News;
import io.gs2.news.model.SetCookieRequestEntry;
import io.gs2.news.request.WantGrantByUserIdRequest;
import io.gs2.news.result.WantGrantByUserIdResult;

public class NewsDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2NewsRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String parentKey;
    String browserUrl;
    String zipUrl;

    public String getBrowserUrl() {
        return this.browserUrl;
    }

    public String getZipUrl() {
        return this.zipUrl;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public NewsDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2NewsRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "News");
    }

    public SetCookieRequestEntryDomain[] wantGrant(WantGrantByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        WantGrantByUserIdResult result = this.client.wantGrantByUserId(request);
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "SetCookieRequestEntry");
        for (SetCookieRequestEntry item : result.getItems()) {
            if (item == null) continue;
            this.cache.put(parentKey, SetCookieRequestEntryDomain.createCacheKey(item.getKey() != null ? item.getKey().toString() : null, item.getValue() != null ? item.getValue().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        SetCookieRequestEntryDomain[] domain = new SetCookieRequestEntryDomain[result.getItems().size()];
        for (int i = 0; i < result.getItems().size(); ++i) {
            domain[i] = new SetCookieRequestEntryDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), request.getUserId(), result.getItems().get(i).getKey(), result.getItems().get(i).getValue());
        }
        this.browserUrl = result.getBrowserUrl();
        this.zipUrl = result.getZipUrl();
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "news", namespaceName, userId, childType);
    }

    public static String createCacheKey() {
        return "Singleton";
    }

    public News model() {
        News value = this.cache.get(this.parentKey, NewsDomain.createCacheKey(), News.class);
        return value;
    }
}

