/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.news.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.news.Gs2NewsRestClient;
import io.gs2.news.domain.model.NamespaceDomain;
import io.gs2.news.request.PrepareUpdateCurrentNewsMasterFromGitHubRequest;
import io.gs2.news.request.PrepareUpdateCurrentNewsMasterRequest;
import io.gs2.news.request.UpdateCurrentNewsMasterRequest;
import io.gs2.news.result.PrepareUpdateCurrentNewsMasterFromGitHubResult;
import io.gs2.news.result.PrepareUpdateCurrentNewsMasterResult;
import io.gs2.news.result.UpdateCurrentNewsMasterResult;

public class CurrentNewsMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2NewsRestClient client;
    private final String namespaceName;
    private final String parentKey;
    String uploadToken;
    String templateUploadUrl;

    public String getUploadToken() {
        return this.uploadToken;
    }

    public String getTemplateUploadUrl() {
        return this.templateUploadUrl;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public CurrentNewsMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2NewsRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CurrentNewsMaster");
    }

    public CurrentNewsMasterDomain prepareUpdate(PrepareUpdateCurrentNewsMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        PrepareUpdateCurrentNewsMasterResult result = this.client.prepareUpdateCurrentNewsMaster(request);
        CurrentNewsMasterDomain domain = this;
        this.uploadToken = result.getUploadToken();
        this.templateUploadUrl = result.getTemplateUploadUrl();
        return domain;
    }

    public CurrentNewsMasterDomain update(UpdateCurrentNewsMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentNewsMasterResult result = this.client.updateCurrentNewsMaster(request);
        CurrentNewsMasterDomain domain = this;
        return domain;
    }

    public CurrentNewsMasterDomain prepareUpdateFromGitHub(PrepareUpdateCurrentNewsMasterFromGitHubRequest request) {
        request.withNamespaceName(this.namespaceName);
        PrepareUpdateCurrentNewsMasterFromGitHubResult result = this.client.prepareUpdateCurrentNewsMasterFromGitHub(request);
        CurrentNewsMasterDomain domain = this;
        this.uploadToken = result.getUploadToken();
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "news", namespaceName, childType);
    }

    public static String createCacheKey(String namespaceName) {
        return String.join((CharSequence)":", namespaceName);
    }
}

