/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.news.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.news.Gs2NewsRestClient;
import io.gs2.news.domain.model.NewsDomain;
import io.gs2.news.domain.model.UserDomain;
import io.gs2.news.model.News;
import io.gs2.news.request.DescribeNewsByUserIdRequest;
import io.gs2.news.result.DescribeNewsByUserIdResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeNewsByUserIdIterator
implements Iterator<News>,
Iterable<News> {
    CacheDatabase cache;
    Gs2NewsRestClient client;
    String namespaceName;
    String userId;
    boolean last;
    List<News> result;
    Integer fetchSize;

    public DescribeNewsByUserIdIterator(CacheDatabase cache, Gs2NewsRestClient client, String namespaceName, String userId) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.last = false;
        this.result = new ArrayList<News>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "News");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, News.class)) {
            this.result = this.cache.list(parentKey, News.class).stream().collect(Collectors.toList());
            this.last = true;
        } else {
            DescribeNewsByUserIdResult r = this.client.describeNewsByUserId(new DescribeNewsByUserIdRequest().withNamespaceName(this.namespaceName).withUserId(this.userId));
            this.result = r.getItems();
            this.last = true;
            for (News item : this.result) {
                this.cache.put(parentKey, NewsDomain.createCacheKey(), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, News.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public News next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        News ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<News> iterator() {
        return this;
    }
}

