/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.money.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.money.Gs2MoneyRestClient;
import io.gs2.money.domain.model.UserDomain;
import io.gs2.money.model.Receipt;
import io.gs2.money.request.GetByUserIdAndTransactionIdRequest;
import io.gs2.money.result.GetByUserIdAndTransactionIdResult;

public class ReceiptDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MoneyRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String transactionId;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public ReceiptDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String transactionId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MoneyRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.transactionId = transactionId;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Receipt");
    }

    public ReceiptDomain getByUserIdAndTransactionId(GetByUserIdAndTransactionIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withTransactionId(this.transactionId);
        GetByUserIdAndTransactionIdResult result = this.client.getByUserIdAndTransactionId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ReceiptDomain.createCacheKey(request.getTransactionId() != null ? request.getTransactionId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ReceiptDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String transactionId, String childType) {
        return String.join((CharSequence)":", "money", namespaceName, userId, transactionId, childType);
    }

    public static String createCacheKey(String transactionId) {
        return String.join((CharSequence)":", transactionId);
    }

    public Receipt model() {
        Receipt value = this.cache.get(this.parentKey, ReceiptDomain.createCacheKey(this.getTransactionId() != null ? this.getTransactionId().toString() : null), Receipt.class);
        return value;
    }
}

