/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.money.domain;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.jobQueue.model.Job;
import io.gs2.jobQueue.model.JobResultBody;
import io.gs2.money.Gs2MoneyRestClient;
import io.gs2.money.domain.iterator.DescribeNamespacesIterator;
import io.gs2.money.domain.model.NamespaceDomain;
import io.gs2.money.domain.model.ReceiptDomain;
import io.gs2.money.domain.model.UserDomain;
import io.gs2.money.domain.model.WalletDomain;
import io.gs2.money.request.CreateNamespaceRequest;
import io.gs2.money.request.DepositByUserIdRequest;
import io.gs2.money.request.RecordReceiptRequest;
import io.gs2.money.request.WithdrawByUserIdRequest;
import io.gs2.money.result.CreateNamespaceResult;
import io.gs2.money.result.DepositByUserIdResult;
import io.gs2.money.result.RecordReceiptResult;
import io.gs2.money.result.WithdrawByUserIdResult;

public class Gs2Money {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MoneyRestClient client;
    private final String parentKey;

    public Gs2Money(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MoneyRestClient(session);
        this.parentKey = "money";
    }

    public NamespaceDomain createNamespace(CreateNamespaceRequest request) {
        CreateNamespaceResult result = this.client.createNamespace(request);
        String parentKey = "money:Namespace";
        if (result.getItem() != null) {
            this.cache.put(parentKey, NamespaceDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        NamespaceDomain domain = new NamespaceDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, result.getItem().getName());
        return domain;
    }

    public DescribeNamespacesIterator namespaces() {
        return new DescribeNamespacesIterator(this.cache, this.client);
    }

    public NamespaceDomain namespace(String namespaceName) {
        return new NamespaceDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, namespaceName);
    }

    public static void updateCacheFromStampSheet(CacheDatabase cache, String method, String request, String result) {
        try {
            switch (method) {
                case "DepositByUserId": {
                    DepositByUserIdRequest requestModel = DepositByUserIdRequest.fromJson(new ObjectMapper().readTree(request));
                    DepositByUserIdResult resultModel = DepositByUserIdResult.fromJson(new ObjectMapper().readTree(result));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Wallet");
                    String key = WalletDomain.createCacheKey(resultModel.getItem().getSlot().toString());
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static void updateCacheFromStampTask(CacheDatabase cache, String method, String request, String result) {
        try {
            switch (method) {
                case "WithdrawByUserId": {
                    WithdrawByUserIdRequest requestModel = WithdrawByUserIdRequest.fromJson(new ObjectMapper().readTree(request));
                    WithdrawByUserIdResult resultModel = WithdrawByUserIdResult.fromJson(new ObjectMapper().readTree(result));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Wallet");
                    String key = WalletDomain.createCacheKey(resultModel.getItem().getSlot().toString());
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
                case "RecordReceipt": {
                    RecordReceiptRequest requestModel = RecordReceiptRequest.fromJson(new ObjectMapper().readTree(request));
                    RecordReceiptResult resultModel = RecordReceiptResult.fromJson(new ObjectMapper().readTree(result));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Receipt");
                    String key = ReceiptDomain.createCacheKey(resultModel.getItem().getTransactionId().toString());
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static void updateCacheFromJobResult(CacheDatabase cache, String method, Job job, JobResultBody result) {
        try {
            switch (method) {
                case "deposit_by_user_id": {
                    DepositByUserIdRequest requestModel = DepositByUserIdRequest.fromJson(new ObjectMapper().readTree(job.getArgs()));
                    DepositByUserIdResult resultModel = DepositByUserIdResult.fromJson(new ObjectMapper().readTree(result.getResult()));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Wallet");
                    String key = WalletDomain.createCacheKey(resultModel.getItem().getSlot().toString());
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }
}

