/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.mission.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.mission.Gs2MissionRestClient;
import io.gs2.mission.domain.iterator.DescribeCompletesByUserIdIterator;
import io.gs2.mission.domain.iterator.DescribeCountersByUserIdIterator;
import io.gs2.mission.domain.model.CompleteDomain;
import io.gs2.mission.domain.model.CounterDomain;
import io.gs2.mission.domain.model.NamespaceDomain;

public class UserDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MissionRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String parentKey;
    String nextPageToken;

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public UserDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MissionRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "User");
    }

    public DescribeCountersByUserIdIterator counters() {
        return new DescribeCountersByUserIdIterator(this.cache, this.client, this.namespaceName, this.userId);
    }

    public CounterDomain counter(String counterName) {
        return new CounterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, counterName);
    }

    public DescribeCompletesByUserIdIterator completes() {
        return new DescribeCompletesByUserIdIterator(this.cache, this.client, this.namespaceName, this.userId);
    }

    public CompleteDomain complete(String missionGroupName) {
        return new CompleteDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, missionGroupName);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "mission", namespaceName, userId, childType);
    }

    public static String createCacheKey(String userId) {
        return String.join((CharSequence)":", userId);
    }
}

