/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.mission.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.mission.Gs2MissionRestClient;
import io.gs2.mission.domain.iterator.DescribeCounterModelMastersIterator;
import io.gs2.mission.domain.iterator.DescribeCounterModelsIterator;
import io.gs2.mission.domain.iterator.DescribeMissionGroupModelMastersIterator;
import io.gs2.mission.domain.iterator.DescribeMissionGroupModelsIterator;
import io.gs2.mission.domain.model.CounterModelDomain;
import io.gs2.mission.domain.model.CounterModelMasterDomain;
import io.gs2.mission.domain.model.CurrentMissionMasterDomain;
import io.gs2.mission.domain.model.MissionGroupModelDomain;
import io.gs2.mission.domain.model.MissionGroupModelMasterDomain;
import io.gs2.mission.domain.model.UserAccessTokenDomain;
import io.gs2.mission.domain.model.UserDomain;
import io.gs2.mission.model.Namespace;
import io.gs2.mission.request.CreateCounterModelMasterRequest;
import io.gs2.mission.request.CreateMissionGroupModelMasterRequest;
import io.gs2.mission.request.DeleteNamespaceRequest;
import io.gs2.mission.request.GetNamespaceRequest;
import io.gs2.mission.request.GetNamespaceStatusRequest;
import io.gs2.mission.request.UpdateNamespaceRequest;
import io.gs2.mission.result.CreateCounterModelMasterResult;
import io.gs2.mission.result.CreateMissionGroupModelMasterResult;
import io.gs2.mission.result.DeleteNamespaceResult;
import io.gs2.mission.result.GetNamespaceResult;
import io.gs2.mission.result.GetNamespaceStatusResult;
import io.gs2.mission.result.UpdateNamespaceResult;

public class NamespaceDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MissionRestClient client;
    private final String namespaceName;
    private final String parentKey;
    String status;
    String nextPageToken;

    public String getStatus() {
        return this.status;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public NamespaceDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MissionRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = "mission:Namespace";
    }

    public NamespaceDomain getStatus(GetNamespaceStatusRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetNamespaceStatusResult result = this.client.getNamespaceStatus(request);
        NamespaceDomain domain = this;
        this.status = result.getStatus();
        return domain;
    }

    private Namespace get(GetNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetNamespaceResult result = this.client.getNamespace(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public NamespaceDomain update(UpdateNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateNamespaceResult result = this.client.updateNamespace(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        NamespaceDomain domain = this;
        return domain;
    }

    public NamespaceDomain delete(DeleteNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        DeleteNamespaceResult result = null;
        try {
            result = this.client.deleteNamespace(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), Namespace.class);
        NamespaceDomain domain = this;
        return domain;
    }

    public MissionGroupModelMasterDomain createMissionGroupModelMaster(CreateMissionGroupModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        CreateMissionGroupModelMasterResult result = this.client.createMissionGroupModelMaster(request);
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "MissionGroupModelMaster");
        if (result.getItem() != null) {
            this.cache.put(parentKey, MissionGroupModelMasterDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        MissionGroupModelMasterDomain domain = new MissionGroupModelMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getName());
        return domain;
    }

    public CounterModelMasterDomain createCounterModelMaster(CreateCounterModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        CreateCounterModelMasterResult result = this.client.createCounterModelMaster(request);
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CounterModelMaster");
        if (result.getItem() != null) {
            this.cache.put(parentKey, CounterModelMasterDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CounterModelMasterDomain domain = new CounterModelMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getName());
        return domain;
    }

    public CurrentMissionMasterDomain currentMissionMaster() {
        return new CurrentMissionMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName);
    }

    public DescribeMissionGroupModelsIterator missionGroupModels() {
        return new DescribeMissionGroupModelsIterator(this.cache, this.client, this.namespaceName);
    }

    public MissionGroupModelDomain missionGroupModel(String missionGroupName) {
        return new MissionGroupModelDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, missionGroupName);
    }

    public DescribeCounterModelsIterator counterModels() {
        return new DescribeCounterModelsIterator(this.cache, this.client, this.namespaceName);
    }

    public CounterModelDomain counterModel(String counterName) {
        return new CounterModelDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, counterName);
    }

    public UserDomain user(String userId) {
        return new UserDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, userId);
    }

    public UserAccessTokenDomain accessToken(AccessToken accessToken) {
        return new UserAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, accessToken);
    }

    public DescribeMissionGroupModelMastersIterator missionGroupModelMasters() {
        return new DescribeMissionGroupModelMastersIterator(this.cache, this.client, this.namespaceName);
    }

    public MissionGroupModelMasterDomain missionGroupModelMaster(String missionGroupName) {
        return new MissionGroupModelMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, missionGroupName);
    }

    public DescribeCounterModelMastersIterator counterModelMasters() {
        return new DescribeCounterModelMastersIterator(this.cache, this.client, this.namespaceName);
    }

    public CounterModelMasterDomain counterModelMaster(String counterName) {
        return new CounterModelMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, counterName);
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "mission", namespaceName, childType);
    }

    public static String createCacheKey(String namespaceName) {
        return String.join((CharSequence)":", namespaceName);
    }

    public Namespace model() {
        Namespace value = this.cache.get(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
        if (value == null) {
            try {
                this.get(new GetNamespaceRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
            }
            value = this.cache.get(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
        }
        return value;
    }
}

