/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.mission.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.mission.Gs2MissionRestClient;
import io.gs2.mission.domain.model.MissionGroupModelMasterDomain;
import io.gs2.mission.model.MissionTaskModelMaster;
import io.gs2.mission.request.DeleteMissionTaskModelMasterRequest;
import io.gs2.mission.request.GetMissionTaskModelMasterRequest;
import io.gs2.mission.request.UpdateMissionTaskModelMasterRequest;
import io.gs2.mission.result.DeleteMissionTaskModelMasterResult;
import io.gs2.mission.result.GetMissionTaskModelMasterResult;
import io.gs2.mission.result.UpdateMissionTaskModelMasterResult;

public class MissionTaskModelMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MissionRestClient client;
    private final String namespaceName;
    private final String missionGroupName;
    private final String missionTaskName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getMissionGroupName() {
        return this.missionGroupName;
    }

    public String getMissionTaskName() {
        return this.missionTaskName;
    }

    public MissionTaskModelMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String missionGroupName, String missionTaskName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MissionRestClient(session);
        this.namespaceName = namespaceName;
        this.missionGroupName = missionGroupName;
        this.missionTaskName = missionTaskName;
        this.parentKey = MissionGroupModelMasterDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.missionGroupName != null ? this.missionGroupName.toString() : null, "MissionTaskModelMaster");
    }

    private MissionTaskModelMaster get(GetMissionTaskModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withMissionGroupName(this.missionGroupName).withMissionTaskName(this.missionTaskName);
        GetMissionTaskModelMasterResult result = this.client.getMissionTaskModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MissionTaskModelMasterDomain.createCacheKey(request.getMissionTaskName() != null ? request.getMissionTaskName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public MissionTaskModelMasterDomain update(UpdateMissionTaskModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withMissionGroupName(this.missionGroupName).withMissionTaskName(this.missionTaskName);
        UpdateMissionTaskModelMasterResult result = this.client.updateMissionTaskModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MissionTaskModelMasterDomain.createCacheKey(request.getMissionTaskName() != null ? request.getMissionTaskName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        MissionTaskModelMasterDomain domain = this;
        return domain;
    }

    public MissionTaskModelMasterDomain delete(DeleteMissionTaskModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withMissionGroupName(this.missionGroupName).withMissionTaskName(this.missionTaskName);
        DeleteMissionTaskModelMasterResult result = null;
        try {
            result = this.client.deleteMissionTaskModelMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, MissionTaskModelMasterDomain.createCacheKey(request.getMissionTaskName() != null ? request.getMissionTaskName().toString() : null), MissionTaskModelMaster.class);
        MissionTaskModelMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String missionGroupName, String missionTaskName, String childType) {
        return String.join((CharSequence)":", "mission", namespaceName, missionGroupName, missionTaskName, childType);
    }

    public static String createCacheKey(String missionTaskName) {
        return String.join((CharSequence)":", missionTaskName);
    }

    public MissionTaskModelMaster model() {
        MissionTaskModelMaster value = this.cache.get(this.parentKey, MissionTaskModelMasterDomain.createCacheKey(this.getMissionTaskName() != null ? this.getMissionTaskName().toString() : null), MissionTaskModelMaster.class);
        if (value == null) {
            try {
                this.get(new GetMissionTaskModelMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, MissionTaskModelMasterDomain.createCacheKey(this.getMissionTaskName() != null ? this.getMissionTaskName().toString() : null), MissionTaskModelMaster.class);
            }
            value = this.cache.get(this.parentKey, MissionTaskModelMasterDomain.createCacheKey(this.getMissionTaskName() != null ? this.getMissionTaskName().toString() : null), MissionTaskModelMaster.class);
        }
        return value;
    }
}

