/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.mission.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.mission.Gs2MissionRestClient;
import io.gs2.mission.domain.iterator.DescribeMissionTaskModelsIterator;
import io.gs2.mission.domain.model.MissionTaskModelDomain;
import io.gs2.mission.domain.model.NamespaceDomain;
import io.gs2.mission.model.MissionGroupModel;
import io.gs2.mission.request.GetMissionGroupModelRequest;
import io.gs2.mission.result.GetMissionGroupModelResult;

public class MissionGroupModelDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MissionRestClient client;
    private final String namespaceName;
    private final String missionGroupName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getMissionGroupName() {
        return this.missionGroupName;
    }

    public MissionGroupModelDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String missionGroupName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MissionRestClient(session);
        this.namespaceName = namespaceName;
        this.missionGroupName = missionGroupName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "MissionGroupModel");
    }

    private MissionGroupModel get(GetMissionGroupModelRequest request) {
        request.withNamespaceName(this.namespaceName).withMissionGroupName(this.missionGroupName);
        GetMissionGroupModelResult result = this.client.getMissionGroupModel(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MissionGroupModelDomain.createCacheKey(request.getMissionGroupName() != null ? request.getMissionGroupName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public DescribeMissionTaskModelsIterator missionTaskModels() {
        return new DescribeMissionTaskModelsIterator(this.cache, this.client, this.namespaceName, this.missionGroupName);
    }

    public MissionTaskModelDomain missionTaskModel(String missionTaskName) {
        return new MissionTaskModelDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.missionGroupName, missionTaskName);
    }

    public static String createCacheParentKey(String namespaceName, String missionGroupName, String childType) {
        return String.join((CharSequence)":", "mission", namespaceName, missionGroupName, childType);
    }

    public static String createCacheKey(String missionGroupName) {
        return String.join((CharSequence)":", missionGroupName);
    }

    public MissionGroupModel model() {
        MissionGroupModel value = this.cache.get(this.parentKey, MissionGroupModelDomain.createCacheKey(this.getMissionGroupName() != null ? this.getMissionGroupName().toString() : null), MissionGroupModel.class);
        if (value == null) {
            try {
                this.get(new GetMissionGroupModelRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, MissionGroupModelDomain.createCacheKey(this.getMissionGroupName() != null ? this.getMissionGroupName().toString() : null), MissionGroupModel.class);
            }
            value = this.cache.get(this.parentKey, MissionGroupModelDomain.createCacheKey(this.getMissionGroupName() != null ? this.getMissionGroupName().toString() : null), MissionGroupModel.class);
        }
        return value;
    }
}

