/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.mission.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.mission.Gs2MissionRestClient;
import io.gs2.mission.domain.model.NamespaceDomain;
import io.gs2.mission.model.CurrentMissionMaster;
import io.gs2.mission.request.ExportMasterRequest;
import io.gs2.mission.request.GetCurrentMissionMasterRequest;
import io.gs2.mission.request.UpdateCurrentMissionMasterFromGitHubRequest;
import io.gs2.mission.request.UpdateCurrentMissionMasterRequest;
import io.gs2.mission.result.ExportMasterResult;
import io.gs2.mission.result.GetCurrentMissionMasterResult;
import io.gs2.mission.result.UpdateCurrentMissionMasterFromGitHubResult;
import io.gs2.mission.result.UpdateCurrentMissionMasterResult;

public class CurrentMissionMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MissionRestClient client;
    private final String namespaceName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public CurrentMissionMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MissionRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CurrentMissionMaster");
    }

    public CurrentMissionMasterDomain exportMaster(ExportMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        ExportMasterResult result = this.client.exportMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentMissionMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentMissionMasterDomain domain = this;
        return domain;
    }

    private CurrentMissionMaster get(GetCurrentMissionMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetCurrentMissionMasterResult result = this.client.getCurrentMissionMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentMissionMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public CurrentMissionMasterDomain update(UpdateCurrentMissionMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentMissionMasterResult result = this.client.updateCurrentMissionMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentMissionMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentMissionMasterDomain domain = this;
        return domain;
    }

    public CurrentMissionMasterDomain updateFromGitHub(UpdateCurrentMissionMasterFromGitHubRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentMissionMasterFromGitHubResult result = this.client.updateCurrentMissionMasterFromGitHub(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentMissionMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentMissionMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "mission", namespaceName, childType);
    }

    public static String createCacheKey(String namespaceName) {
        return String.join((CharSequence)":", namespaceName);
    }

    public CurrentMissionMaster model() {
        CurrentMissionMaster value = this.cache.get(this.parentKey, CurrentMissionMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentMissionMaster.class);
        if (value == null) {
            try {
                this.get(new GetCurrentMissionMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CurrentMissionMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentMissionMaster.class);
            }
            value = this.cache.get(this.parentKey, CurrentMissionMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentMissionMaster.class);
        }
        return value;
    }
}

