/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.mission.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.mission.Gs2MissionRestClient;
import io.gs2.mission.domain.model.NamespaceDomain;
import io.gs2.mission.model.CounterModel;
import io.gs2.mission.request.GetCounterModelRequest;
import io.gs2.mission.result.GetCounterModelResult;

public class CounterModelDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MissionRestClient client;
    private final String namespaceName;
    private final String counterName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getCounterName() {
        return this.counterName;
    }

    public CounterModelDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String counterName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MissionRestClient(session);
        this.namespaceName = namespaceName;
        this.counterName = counterName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CounterModel");
    }

    private CounterModel get(GetCounterModelRequest request) {
        request.withNamespaceName(this.namespaceName).withCounterName(this.counterName);
        GetCounterModelResult result = this.client.getCounterModel(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CounterModelDomain.createCacheKey(request.getCounterName() != null ? request.getCounterName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public static String createCacheParentKey(String namespaceName, String counterName, String childType) {
        return String.join((CharSequence)":", "mission", namespaceName, counterName, childType);
    }

    public static String createCacheKey(String counterName) {
        return String.join((CharSequence)":", counterName);
    }

    public CounterModel model() {
        CounterModel value = this.cache.get(this.parentKey, CounterModelDomain.createCacheKey(this.getCounterName() != null ? this.getCounterName().toString() : null), CounterModel.class);
        if (value == null) {
            try {
                this.get(new GetCounterModelRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CounterModelDomain.createCacheKey(this.getCounterName() != null ? this.getCounterName().toString() : null), CounterModel.class);
            }
            value = this.cache.get(this.parentKey, CounterModelDomain.createCacheKey(this.getCounterName() != null ? this.getCounterName().toString() : null), CounterModel.class);
        }
        return value;
    }
}

