/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.mission.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.mission.Gs2MissionRestClient;
import io.gs2.mission.domain.model.UserDomain;
import io.gs2.mission.model.Complete;
import io.gs2.mission.model.Counter;
import io.gs2.mission.model.ScopedValue;
import io.gs2.mission.request.DeleteCounterByUserIdRequest;
import io.gs2.mission.request.GetCounterByUserIdRequest;
import io.gs2.mission.request.IncreaseCounterByUserIdRequest;
import io.gs2.mission.result.DeleteCounterByUserIdResult;
import io.gs2.mission.result.GetCounterByUserIdResult;
import io.gs2.mission.result.IncreaseCounterByUserIdResult;

public class CounterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MissionRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String counterName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getCounterName() {
        return this.counterName;
    }

    public CounterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String counterName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MissionRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.counterName = counterName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Counter");
    }

    public CounterDomain increase(IncreaseCounterByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withCounterName(this.counterName);
        IncreaseCounterByUserIdResult result = this.client.increaseCounterByUserId(request);
        this.cache.listCacheClear(this.parentKey.replace("Counter", "Complete"), Complete.class);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CounterDomain.createCacheKey(request.getCounterName() != null ? request.getCounterName().toString() : null), result.getItem(), result.getItem().getValues().stream().map(ScopedValue::getNextResetAt).map(i -> i == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : i).min((i, j) -> (int)(i - j)).orElse(System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes));
        }
        CounterDomain domain = this;
        return domain;
    }

    private Counter get(GetCounterByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withCounterName(this.counterName);
        GetCounterByUserIdResult result = this.client.getCounterByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CounterDomain.createCacheKey(request.getCounterName() != null ? request.getCounterName().toString() : null), result.getItem(), result.getItem().getValues().stream().map(ScopedValue::getNextResetAt).map(i -> i == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : i).min((i, j) -> (int)(i - j)).orElse(System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes));
        }
        return result.getItem();
    }

    public CounterDomain delete(DeleteCounterByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withCounterName(this.counterName);
        DeleteCounterByUserIdResult result = null;
        try {
            result = this.client.deleteCounterByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, CounterDomain.createCacheKey(request.getCounterName() != null ? request.getCounterName().toString() : null), Counter.class);
        CounterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String counterName, String childType) {
        return String.join((CharSequence)":", "mission", namespaceName, userId, counterName, childType);
    }

    public static String createCacheKey(String counterName) {
        return String.join((CharSequence)":", counterName);
    }

    public Counter model() {
        Counter value = this.cache.get(this.parentKey, CounterDomain.createCacheKey(this.getCounterName() != null ? this.getCounterName().toString() : null), Counter.class);
        if (value == null) {
            try {
                this.get(new GetCounterByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CounterDomain.createCacheKey(this.getCounterName() != null ? this.getCounterName().toString() : null), Counter.class);
            }
            value = this.cache.get(this.parentKey, CounterDomain.createCacheKey(this.getCounterName() != null ? this.getCounterName().toString() : null), Counter.class);
        }
        return value;
    }
}

