/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.mission.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.domain.StampSheetDomain;
import io.gs2.core.exception.Gs2Exception;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.exception.TransactionException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.mission.Gs2MissionRestClient;
import io.gs2.mission.domain.model.CompleteDomain;
import io.gs2.mission.domain.model.UserDomain;
import io.gs2.mission.model.Complete;
import io.gs2.mission.request.CompleteRequest;
import io.gs2.mission.request.GetCompleteRequest;
import io.gs2.mission.result.CompleteResult;
import io.gs2.mission.result.GetCompleteResult;

public class CompleteAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MissionRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String missionGroupName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getMissionGroupName() {
        return this.missionGroupName;
    }

    public CompleteAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String missionGroupName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MissionRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.missionGroupName = missionGroupName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Complete");
    }

    public StampSheetDomain complete(CompleteRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withMissionGroupName(this.missionGroupName);
        CompleteResult result = this.client.complete(request);
        StampSheetDomain stampSheet = new StampSheetDomain(this.cache, this.jobQueueDomain, this.session, result.getStampSheet(), result.getStampSheetEncryptionKeyId(), this.stampSheetConfiguration.namespaceName, this.stampSheetConfiguration.stampTaskEventHandler, this.stampSheetConfiguration.stampSheetEventHandler);
        try {
            stampSheet.run();
        }
        catch (Gs2Exception e) {
            throw new TransactionException(stampSheet, e);
        }
        return stampSheet;
    }

    private Complete get(GetCompleteRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withMissionGroupName(this.missionGroupName);
        GetCompleteResult result = this.client.getComplete(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CompleteDomain.createCacheKey(request.getMissionGroupName() != null ? request.getMissionGroupName().toString() : null), result.getItem(), result.getItem().getNextResetAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : result.getItem().getNextResetAt());
        }
        return result.getItem();
    }

    public static String createCacheParentKey(String namespaceName, String userId, String missionGroupName, String childType) {
        return String.join((CharSequence)":", "mission", namespaceName, userId, missionGroupName, childType);
    }

    public static String createCacheKey(String missionGroupName) {
        return String.join((CharSequence)":", missionGroupName);
    }

    public Complete model() {
        Complete value = this.cache.get(this.parentKey, CompleteDomain.createCacheKey(this.getMissionGroupName() != null ? this.getMissionGroupName().toString() : null), Complete.class);
        if (value == null) {
            try {
                this.get(new GetCompleteRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CompleteDomain.createCacheKey(this.getMissionGroupName() != null ? this.getMissionGroupName().toString() : null), Complete.class);
            }
            value = this.cache.get(this.parentKey, CompleteDomain.createCacheKey(this.getMissionGroupName() != null ? this.getMissionGroupName().toString() : null), Complete.class);
        }
        return value;
    }
}

