/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.mission.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.mission.Gs2MissionRestClient;
import io.gs2.mission.domain.model.MissionGroupModelDomain;
import io.gs2.mission.domain.model.NamespaceDomain;
import io.gs2.mission.model.MissionGroupModel;
import io.gs2.mission.request.DescribeMissionGroupModelsRequest;
import io.gs2.mission.result.DescribeMissionGroupModelsResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeMissionGroupModelsIterator
implements Iterator<MissionGroupModel>,
Iterable<MissionGroupModel> {
    CacheDatabase cache;
    Gs2MissionRestClient client;
    String namespaceName;
    boolean last;
    List<MissionGroupModel> result;
    Integer fetchSize;

    public DescribeMissionGroupModelsIterator(CacheDatabase cache, Gs2MissionRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.last = false;
        this.result = new ArrayList<MissionGroupModel>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "MissionGroupModel");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, MissionGroupModel.class)) {
            this.result = this.cache.list(parentKey, MissionGroupModel.class).stream().collect(Collectors.toList());
            this.last = true;
        } else {
            DescribeMissionGroupModelsResult r = this.client.describeMissionGroupModels(new DescribeMissionGroupModelsRequest().withNamespaceName(this.namespaceName));
            this.result = r.getItems();
            this.last = true;
            for (MissionGroupModel item : this.result) {
                this.cache.put(parentKey, MissionGroupModelDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, MissionGroupModel.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public MissionGroupModel next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        MissionGroupModel ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<MissionGroupModel> iterator() {
        return this;
    }
}

