/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.mission.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.mission.Gs2MissionRestClient;
import io.gs2.mission.domain.model.CounterModelMasterDomain;
import io.gs2.mission.domain.model.NamespaceDomain;
import io.gs2.mission.model.CounterModelMaster;
import io.gs2.mission.request.DescribeCounterModelMastersRequest;
import io.gs2.mission.result.DescribeCounterModelMastersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeCounterModelMastersIterator
implements Iterator<CounterModelMaster>,
Iterable<CounterModelMaster> {
    CacheDatabase cache;
    Gs2MissionRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<CounterModelMaster> result;
    Integer fetchSize;

    public DescribeCounterModelMastersIterator(CacheDatabase cache, Gs2MissionRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<CounterModelMaster>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CounterModelMaster");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, CounterModelMaster.class)) {
            this.result = this.cache.list(parentKey, CounterModelMaster.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeCounterModelMastersResult r = this.client.describeCounterModelMasters(new DescribeCounterModelMastersRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (CounterModelMaster item : this.result) {
                this.cache.put(parentKey, CounterModelMasterDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, CounterModelMaster.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public CounterModelMaster next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        CounterModelMaster ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<CounterModelMaster> iterator() {
        return this;
    }
}

