/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.mission.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.mission.Gs2MissionRestClient;
import io.gs2.mission.domain.model.CompleteDomain;
import io.gs2.mission.domain.model.UserDomain;
import io.gs2.mission.model.Complete;
import io.gs2.mission.request.DescribeCompletesByUserIdRequest;
import io.gs2.mission.result.DescribeCompletesByUserIdResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeCompletesByUserIdIterator
implements Iterator<Complete>,
Iterable<Complete> {
    CacheDatabase cache;
    Gs2MissionRestClient client;
    String namespaceName;
    String userId;
    String pageToken;
    boolean last;
    List<Complete> result;
    Integer fetchSize;

    public DescribeCompletesByUserIdIterator(CacheDatabase cache, Gs2MissionRestClient client, String namespaceName, String userId) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Complete>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Complete");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Complete.class)) {
            this.result = this.cache.list(parentKey, Complete.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeCompletesByUserIdResult r = this.client.describeCompletesByUserId(new DescribeCompletesByUserIdRequest().withNamespaceName(this.namespaceName).withUserId(this.userId).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Complete item : this.result) {
                this.cache.put(parentKey, CompleteDomain.createCacheKey(item.getMissionGroupName() != null ? item.getMissionGroupName().toString() : null), item, item.getNextResetAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : item.getNextResetAt());
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Complete.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Complete next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Complete ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Complete> iterator() {
        return this;
    }
}

