/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.matchmaking.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.matchmaking.Gs2MatchmakingRestClient;
import io.gs2.matchmaking.domain.model.NamespaceDomain;
import io.gs2.matchmaking.model.Vote;
import io.gs2.matchmaking.request.CommitVoteRequest;
import io.gs2.matchmaking.result.CommitVoteResult;

public class VoteDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MatchmakingRestClient client;
    private final String namespaceName;
    private final String ratingName;
    private final String gatheringName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getRatingName() {
        return this.ratingName;
    }

    public String getGatheringName() {
        return this.gatheringName;
    }

    public VoteDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String ratingName, String gatheringName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MatchmakingRestClient(session);
        this.namespaceName = namespaceName;
        this.ratingName = ratingName;
        this.gatheringName = gatheringName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Vote");
    }

    public VoteDomain commit(CommitVoteRequest request) {
        request.withNamespaceName(this.namespaceName).withRatingName(this.ratingName).withGatheringName(this.gatheringName);
        CommitVoteResult result = this.client.commitVote(request);
        VoteDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String ratingName, String gatheringName, String childType) {
        return String.join((CharSequence)":", "matchmaking", namespaceName, ratingName, gatheringName, childType);
    }

    public static String createCacheKey(String ratingName, String gatheringName) {
        return String.join((CharSequence)":", ratingName, gatheringName);
    }

    public Vote model() {
        Vote value = this.cache.get(this.parentKey, VoteDomain.createCacheKey(this.getRatingName() != null ? this.getRatingName().toString() : null, this.getGatheringName() != null ? this.getGatheringName().toString() : null), Vote.class);
        return value;
    }
}

