/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.matchmaking.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.matchmaking.Gs2MatchmakingRestClient;
import io.gs2.matchmaking.domain.iterator.DescribeRatingsIterator;
import io.gs2.matchmaking.domain.iterator.DoMatchmakingIterator;
import io.gs2.matchmaking.domain.model.BallotAccessTokenDomain;
import io.gs2.matchmaking.domain.model.GatheringAccessTokenDomain;
import io.gs2.matchmaking.domain.model.GatheringDomain;
import io.gs2.matchmaking.domain.model.NamespaceDomain;
import io.gs2.matchmaking.domain.model.RatingAccessTokenDomain;
import io.gs2.matchmaking.domain.model.UserDomain;
import io.gs2.matchmaking.model.Player;
import io.gs2.matchmaking.request.CreateGatheringRequest;
import io.gs2.matchmaking.result.CreateGatheringResult;

public class UserAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MatchmakingRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String parentKey;
    String nextPageToken;
    String matchmakingContextToken;

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getMatchmakingContextToken() {
        return this.matchmakingContextToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public UserAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MatchmakingRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "User");
    }

    public GatheringAccessTokenDomain createGathering(CreateGatheringRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null);
        CreateGatheringResult result = this.client.createGathering(request);
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Singleton", "Gathering");
        if (result.getItem() != null) {
            this.cache.put(parentKey, GatheringDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), result.getItem().getExpiresAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : result.getItem().getExpiresAt());
        }
        GatheringAccessTokenDomain domain = new GatheringAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), this.accessToken, result.getItem().getName());
        return domain;
    }

    public BallotAccessTokenDomain ballot(String ratingName, String gatheringName, Integer numberOfPlayer, String keyId) {
        return new BallotAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken, ratingName, gatheringName, numberOfPlayer, keyId);
    }

    public DoMatchmakingIterator doMatchmaking(Player player) {
        return new DoMatchmakingIterator(this.cache, this.client, this.namespaceName, this.accessToken, player);
    }

    public GatheringAccessTokenDomain gathering(String gatheringName) {
        return new GatheringAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken, gatheringName);
    }

    public DescribeRatingsIterator ratings() {
        return new DescribeRatingsIterator(this.cache, this.client, this.namespaceName, this.accessToken);
    }

    public RatingAccessTokenDomain rating(String ratingName) {
        return new RatingAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken, ratingName);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "matchmaking", namespaceName, userId, childType);
    }

    public static String createCacheKey(String userId) {
        return String.join((CharSequence)":", userId);
    }
}

