/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.matchmaking.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.matchmaking.Gs2MatchmakingRestClient;
import io.gs2.matchmaking.domain.model.NamespaceDomain;
import io.gs2.matchmaking.model.RatingModelMaster;
import io.gs2.matchmaking.request.DeleteRatingModelMasterRequest;
import io.gs2.matchmaking.request.GetRatingModelMasterRequest;
import io.gs2.matchmaking.request.UpdateRatingModelMasterRequest;
import io.gs2.matchmaking.result.DeleteRatingModelMasterResult;
import io.gs2.matchmaking.result.GetRatingModelMasterResult;
import io.gs2.matchmaking.result.UpdateRatingModelMasterResult;

public class RatingModelMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MatchmakingRestClient client;
    private final String namespaceName;
    private final String ratingName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getRatingName() {
        return this.ratingName;
    }

    public RatingModelMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String ratingName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MatchmakingRestClient(session);
        this.namespaceName = namespaceName;
        this.ratingName = ratingName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "RatingModelMaster");
    }

    private RatingModelMaster get(GetRatingModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withRatingName(this.ratingName);
        GetRatingModelMasterResult result = this.client.getRatingModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, RatingModelMasterDomain.createCacheKey(request.getRatingName() != null ? request.getRatingName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public RatingModelMasterDomain update(UpdateRatingModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withRatingName(this.ratingName);
        UpdateRatingModelMasterResult result = this.client.updateRatingModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, RatingModelMasterDomain.createCacheKey(request.getRatingName() != null ? request.getRatingName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        RatingModelMasterDomain domain = this;
        return domain;
    }

    public RatingModelMasterDomain delete(DeleteRatingModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withRatingName(this.ratingName);
        DeleteRatingModelMasterResult result = null;
        try {
            result = this.client.deleteRatingModelMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, RatingModelMasterDomain.createCacheKey(request.getRatingName() != null ? request.getRatingName().toString() : null), RatingModelMaster.class);
        RatingModelMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String ratingName, String childType) {
        return String.join((CharSequence)":", "matchmaking", namespaceName, ratingName, childType);
    }

    public static String createCacheKey(String ratingName) {
        return String.join((CharSequence)":", ratingName);
    }

    public RatingModelMaster model() {
        RatingModelMaster value = this.cache.get(this.parentKey, RatingModelMasterDomain.createCacheKey(this.getRatingName() != null ? this.getRatingName().toString() : null), RatingModelMaster.class);
        if (value == null) {
            try {
                this.get(new GetRatingModelMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, RatingModelMasterDomain.createCacheKey(this.getRatingName() != null ? this.getRatingName().toString() : null), RatingModelMaster.class);
            }
            value = this.cache.get(this.parentKey, RatingModelMasterDomain.createCacheKey(this.getRatingName() != null ? this.getRatingName().toString() : null), RatingModelMaster.class);
        }
        return value;
    }
}

