/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.matchmaking.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.matchmaking.Gs2MatchmakingRestClient;
import io.gs2.matchmaking.domain.model.NamespaceDomain;
import io.gs2.matchmaking.model.RatingModel;
import io.gs2.matchmaking.request.GetRatingModelRequest;
import io.gs2.matchmaking.result.GetRatingModelResult;

public class RatingModelDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MatchmakingRestClient client;
    private final String namespaceName;
    private final String ratingName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getRatingName() {
        return this.ratingName;
    }

    public RatingModelDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String ratingName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MatchmakingRestClient(session);
        this.namespaceName = namespaceName;
        this.ratingName = ratingName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "RatingModel");
    }

    private RatingModel get(GetRatingModelRequest request) {
        request.withNamespaceName(this.namespaceName).withRatingName(this.ratingName);
        GetRatingModelResult result = this.client.getRatingModel(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, RatingModelDomain.createCacheKey(request.getRatingName() != null ? request.getRatingName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public static String createCacheParentKey(String namespaceName, String ratingName, String childType) {
        return String.join((CharSequence)":", "matchmaking", namespaceName, ratingName, childType);
    }

    public static String createCacheKey(String ratingName) {
        return String.join((CharSequence)":", ratingName);
    }

    public RatingModel model() {
        RatingModel value = this.cache.get(this.parentKey, RatingModelDomain.createCacheKey(this.getRatingName() != null ? this.getRatingName().toString() : null), RatingModel.class);
        if (value == null) {
            try {
                this.get(new GetRatingModelRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, RatingModelDomain.createCacheKey(this.getRatingName() != null ? this.getRatingName().toString() : null), RatingModel.class);
            }
            value = this.cache.get(this.parentKey, RatingModelDomain.createCacheKey(this.getRatingName() != null ? this.getRatingName().toString() : null), RatingModel.class);
        }
        return value;
    }
}

