/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.matchmaking.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.matchmaking.Gs2MatchmakingRestClient;
import io.gs2.matchmaking.domain.model.UserDomain;
import io.gs2.matchmaking.model.Rating;
import io.gs2.matchmaking.request.DeleteRatingRequest;
import io.gs2.matchmaking.request.GetRatingByUserIdRequest;
import io.gs2.matchmaking.result.DeleteRatingResult;
import io.gs2.matchmaking.result.GetRatingByUserIdResult;

public class RatingDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MatchmakingRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String ratingName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getRatingName() {
        return this.ratingName;
    }

    public RatingDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String ratingName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MatchmakingRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.ratingName = ratingName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Rating");
    }

    private Rating get(GetRatingByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withRatingName(this.ratingName);
        GetRatingByUserIdResult result = this.client.getRatingByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, RatingDomain.createCacheKey(request.getRatingName() != null ? request.getRatingName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public RatingDomain delete(DeleteRatingRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withRatingName(this.ratingName);
        DeleteRatingResult result = null;
        try {
            result = this.client.deleteRating(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, RatingDomain.createCacheKey(request.getRatingName() != null ? request.getRatingName().toString() : null), Rating.class);
        RatingDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String ratingName, String childType) {
        return String.join((CharSequence)":", "matchmaking", namespaceName, userId, ratingName, childType);
    }

    public static String createCacheKey(String ratingName) {
        return String.join((CharSequence)":", ratingName);
    }

    public Rating model() {
        Rating value = this.cache.get(this.parentKey, RatingDomain.createCacheKey(this.getRatingName() != null ? this.getRatingName().toString() : null), Rating.class);
        if (value == null) {
            try {
                this.get(new GetRatingByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, RatingDomain.createCacheKey(this.getRatingName() != null ? this.getRatingName().toString() : null), Rating.class);
            }
            value = this.cache.get(this.parentKey, RatingDomain.createCacheKey(this.getRatingName() != null ? this.getRatingName().toString() : null), Rating.class);
        }
        return value;
    }
}

