/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.matchmaking.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.matchmaking.Gs2MatchmakingRestClient;
import io.gs2.matchmaking.domain.model.RatingDomain;
import io.gs2.matchmaking.domain.model.UserDomain;
import io.gs2.matchmaking.model.Rating;
import io.gs2.matchmaking.request.GetRatingRequest;
import io.gs2.matchmaking.result.GetRatingResult;

public class RatingAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MatchmakingRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String ratingName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getRatingName() {
        return this.ratingName;
    }

    public RatingAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String ratingName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MatchmakingRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.ratingName = ratingName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Rating");
    }

    private Rating get(GetRatingRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withRatingName(this.ratingName);
        GetRatingResult result = this.client.getRating(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, RatingDomain.createCacheKey(request.getRatingName() != null ? request.getRatingName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public static String createCacheParentKey(String namespaceName, String userId, String ratingName, String childType) {
        return String.join((CharSequence)":", "matchmaking", namespaceName, userId, ratingName, childType);
    }

    public static String createCacheKey(String ratingName) {
        return String.join((CharSequence)":", ratingName);
    }

    public Rating model() {
        Rating value = this.cache.get(this.parentKey, RatingDomain.createCacheKey(this.getRatingName() != null ? this.getRatingName().toString() : null), Rating.class);
        if (value == null) {
            try {
                this.get(new GetRatingRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, RatingDomain.createCacheKey(this.getRatingName() != null ? this.getRatingName().toString() : null), Rating.class);
            }
            value = this.cache.get(this.parentKey, RatingDomain.createCacheKey(this.getRatingName() != null ? this.getRatingName().toString() : null), Rating.class);
        }
        return value;
    }
}

