/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.matchmaking.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.matchmaking.Gs2MatchmakingRestClient;
import io.gs2.matchmaking.domain.iterator.DescribeRatingModelMastersIterator;
import io.gs2.matchmaking.domain.iterator.DescribeRatingModelsIterator;
import io.gs2.matchmaking.domain.model.BallotDomain;
import io.gs2.matchmaking.domain.model.CurrentRatingModelMasterDomain;
import io.gs2.matchmaking.domain.model.RatingModelDomain;
import io.gs2.matchmaking.domain.model.RatingModelMasterDomain;
import io.gs2.matchmaking.domain.model.UserAccessTokenDomain;
import io.gs2.matchmaking.domain.model.UserDomain;
import io.gs2.matchmaking.domain.model.VoteDomain;
import io.gs2.matchmaking.model.Namespace;
import io.gs2.matchmaking.request.CreateRatingModelMasterRequest;
import io.gs2.matchmaking.request.DeleteNamespaceRequest;
import io.gs2.matchmaking.request.GetNamespaceRequest;
import io.gs2.matchmaking.request.GetNamespaceStatusRequest;
import io.gs2.matchmaking.request.UpdateNamespaceRequest;
import io.gs2.matchmaking.request.VoteMultipleRequest;
import io.gs2.matchmaking.request.VoteRequest;
import io.gs2.matchmaking.result.CreateRatingModelMasterResult;
import io.gs2.matchmaking.result.DeleteNamespaceResult;
import io.gs2.matchmaking.result.GetNamespaceResult;
import io.gs2.matchmaking.result.GetNamespaceStatusResult;
import io.gs2.matchmaking.result.UpdateNamespaceResult;
import io.gs2.matchmaking.result.VoteMultipleResult;
import io.gs2.matchmaking.result.VoteResult;

public class NamespaceDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MatchmakingRestClient client;
    private final String namespaceName;
    private final String parentKey;
    String status;
    String nextPageToken;

    public String getStatus() {
        return this.status;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public NamespaceDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MatchmakingRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = "matchmaking:Namespace";
    }

    public NamespaceDomain getStatus(GetNamespaceStatusRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetNamespaceStatusResult result = this.client.getNamespaceStatus(request);
        NamespaceDomain domain = this;
        this.status = result.getStatus();
        return domain;
    }

    private Namespace get(GetNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetNamespaceResult result = this.client.getNamespace(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public NamespaceDomain update(UpdateNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateNamespaceResult result = this.client.updateNamespace(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        NamespaceDomain domain = this;
        return domain;
    }

    public NamespaceDomain delete(DeleteNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        DeleteNamespaceResult result = null;
        try {
            result = this.client.deleteNamespace(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), Namespace.class);
        NamespaceDomain domain = this;
        return domain;
    }

    public BallotDomain vote(VoteRequest request) {
        request.withNamespaceName(this.namespaceName);
        VoteResult result = this.client.vote(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, BallotDomain.createCacheKey(result.getItem().getRatingName() != null ? result.getItem().getRatingName().toString() : null, result.getItem().getGatheringName() != null ? result.getItem().getGatheringName().toString() : null, result.getItem().getNumberOfPlayer() != null ? result.getItem().getNumberOfPlayer().toString() : null, request.getKeyId() != null ? request.getKeyId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        BallotDomain domain = new BallotDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getUserId(), result.getItem().getRatingName(), result.getItem().getGatheringName(), result.getItem().getNumberOfPlayer(), request.getKeyId());
        return domain;
    }

    public BallotDomain voteMultiple(VoteMultipleRequest request) {
        request.withNamespaceName(this.namespaceName);
        VoteMultipleResult result = this.client.voteMultiple(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, BallotDomain.createCacheKey(result.getItem().getRatingName() != null ? result.getItem().getRatingName().toString() : null, result.getItem().getGatheringName() != null ? result.getItem().getGatheringName().toString() : null, result.getItem().getNumberOfPlayer() != null ? result.getItem().getNumberOfPlayer().toString() : null, request.getKeyId() != null ? request.getKeyId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        BallotDomain domain = new BallotDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getUserId(), result.getItem().getRatingName(), result.getItem().getGatheringName(), result.getItem().getNumberOfPlayer(), request.getKeyId());
        return domain;
    }

    public RatingModelMasterDomain createRatingModelMaster(CreateRatingModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        CreateRatingModelMasterResult result = this.client.createRatingModelMaster(request);
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "RatingModelMaster");
        if (result.getItem() != null) {
            this.cache.put(parentKey, RatingModelMasterDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        RatingModelMasterDomain domain = new RatingModelMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getName());
        return domain;
    }

    public UserDomain user(String userId) {
        return new UserDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, userId);
    }

    public UserAccessTokenDomain accessToken(AccessToken accessToken) {
        return new UserAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, accessToken);
    }

    public VoteDomain vote(String ratingName, String gatheringName) {
        return new VoteDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, ratingName, gatheringName);
    }

    public CurrentRatingModelMasterDomain currentRatingModelMaster() {
        return new CurrentRatingModelMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName);
    }

    public DescribeRatingModelsIterator ratingModels() {
        return new DescribeRatingModelsIterator(this.cache, this.client, this.namespaceName);
    }

    public RatingModelDomain ratingModel(String ratingName) {
        return new RatingModelDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, ratingName);
    }

    public DescribeRatingModelMastersIterator ratingModelMasters() {
        return new DescribeRatingModelMastersIterator(this.cache, this.client, this.namespaceName);
    }

    public RatingModelMasterDomain ratingModelMaster(String ratingName) {
        return new RatingModelMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, ratingName);
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "matchmaking", namespaceName, childType);
    }

    public static String createCacheKey(String namespaceName) {
        return String.join((CharSequence)":", namespaceName);
    }

    public Namespace model() {
        Namespace value = this.cache.get(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
        if (value == null) {
            try {
                this.get(new GetNamespaceRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
            }
            value = this.cache.get(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
        }
        return value;
    }
}

