/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.matchmaking.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.matchmaking.Gs2MatchmakingRestClient;
import io.gs2.matchmaking.domain.model.GatheringDomain;
import io.gs2.matchmaking.domain.model.UserDomain;
import io.gs2.matchmaking.model.Gathering;
import io.gs2.matchmaking.request.CancelMatchmakingRequest;
import io.gs2.matchmaking.request.UpdateGatheringRequest;
import io.gs2.matchmaking.result.CancelMatchmakingResult;
import io.gs2.matchmaking.result.UpdateGatheringResult;

public class GatheringAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MatchmakingRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String gatheringName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getGatheringName() {
        return this.gatheringName;
    }

    public GatheringAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String gatheringName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MatchmakingRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.gatheringName = gatheringName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Singleton", "Gathering");
    }

    public GatheringAccessTokenDomain update(UpdateGatheringRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withGatheringName(this.gatheringName);
        UpdateGatheringResult result = this.client.updateGathering(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, GatheringDomain.createCacheKey(request.getGatheringName() != null ? request.getGatheringName().toString() : null), result.getItem(), result.getItem().getExpiresAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : result.getItem().getExpiresAt());
        }
        GatheringAccessTokenDomain domain = this;
        return domain;
    }

    public GatheringAccessTokenDomain cancelMatchmaking(CancelMatchmakingRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withGatheringName(this.gatheringName);
        CancelMatchmakingResult result = null;
        try {
            result = this.client.cancelMatchmaking(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, GatheringDomain.createCacheKey(request.getGatheringName() != null ? request.getGatheringName().toString() : null), Gathering.class);
        GatheringAccessTokenDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String gatheringName, String childType) {
        return String.join((CharSequence)":", "matchmaking", namespaceName, userId, gatheringName, childType);
    }

    public static String createCacheKey(String gatheringName) {
        return String.join((CharSequence)":", gatheringName);
    }

    public Gathering model() {
        Gathering value = this.cache.get(this.parentKey, GatheringDomain.createCacheKey(this.getGatheringName() != null ? this.getGatheringName().toString() : null), Gathering.class);
        return value;
    }
}

