/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.matchmaking.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.matchmaking.Gs2MatchmakingRestClient;
import io.gs2.matchmaking.domain.model.NamespaceDomain;
import io.gs2.matchmaking.model.CurrentRatingModelMaster;
import io.gs2.matchmaking.request.ExportMasterRequest;
import io.gs2.matchmaking.request.GetCurrentRatingModelMasterRequest;
import io.gs2.matchmaking.request.UpdateCurrentRatingModelMasterFromGitHubRequest;
import io.gs2.matchmaking.request.UpdateCurrentRatingModelMasterRequest;
import io.gs2.matchmaking.result.ExportMasterResult;
import io.gs2.matchmaking.result.GetCurrentRatingModelMasterResult;
import io.gs2.matchmaking.result.UpdateCurrentRatingModelMasterFromGitHubResult;
import io.gs2.matchmaking.result.UpdateCurrentRatingModelMasterResult;

public class CurrentRatingModelMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MatchmakingRestClient client;
    private final String namespaceName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public CurrentRatingModelMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MatchmakingRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CurrentRatingModelMaster");
    }

    public CurrentRatingModelMasterDomain exportMaster(ExportMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        ExportMasterResult result = this.client.exportMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentRatingModelMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentRatingModelMasterDomain domain = this;
        return domain;
    }

    private CurrentRatingModelMaster get(GetCurrentRatingModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetCurrentRatingModelMasterResult result = this.client.getCurrentRatingModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentRatingModelMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public CurrentRatingModelMasterDomain update(UpdateCurrentRatingModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentRatingModelMasterResult result = this.client.updateCurrentRatingModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentRatingModelMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentRatingModelMasterDomain domain = this;
        return domain;
    }

    public CurrentRatingModelMasterDomain updateFromGitHub(UpdateCurrentRatingModelMasterFromGitHubRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentRatingModelMasterFromGitHubResult result = this.client.updateCurrentRatingModelMasterFromGitHub(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentRatingModelMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentRatingModelMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "matchmaking", namespaceName, childType);
    }

    public static String createCacheKey(String namespaceName) {
        return String.join((CharSequence)":", namespaceName);
    }

    public CurrentRatingModelMaster model() {
        CurrentRatingModelMaster value = this.cache.get(this.parentKey, CurrentRatingModelMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentRatingModelMaster.class);
        if (value == null) {
            try {
                this.get(new GetCurrentRatingModelMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CurrentRatingModelMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentRatingModelMaster.class);
            }
            value = this.cache.get(this.parentKey, CurrentRatingModelMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentRatingModelMaster.class);
        }
        return value;
    }
}

