/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.matchmaking.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.matchmaking.Gs2MatchmakingRestClient;
import io.gs2.matchmaking.domain.model.UserDomain;
import io.gs2.matchmaking.model.Ballot;
import io.gs2.matchmaking.request.GetBallotByUserIdRequest;
import io.gs2.matchmaking.result.GetBallotByUserIdResult;

public class BallotDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MatchmakingRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String ratingName;
    private final String gatheringName;
    private final Integer numberOfPlayer;
    private final String keyId;
    private final String parentKey;
    String body;
    String signature;

    public String getBody() {
        return this.body;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getRatingName() {
        return this.ratingName;
    }

    public String getGatheringName() {
        return this.gatheringName;
    }

    public Integer getNumberOfPlayer() {
        return this.numberOfPlayer;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public BallotDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String ratingName, String gatheringName, Integer numberOfPlayer, String keyId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MatchmakingRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.ratingName = ratingName;
        this.gatheringName = gatheringName;
        this.numberOfPlayer = numberOfPlayer;
        this.keyId = keyId;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Ballot");
    }

    private BallotDomain get(GetBallotByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withRatingName(this.ratingName).withGatheringName(this.gatheringName).withNumberOfPlayer(this.numberOfPlayer).withKeyId(this.keyId);
        GetBallotByUserIdResult result = this.client.getBallotByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, BallotDomain.createCacheKey(request.getRatingName() != null ? request.getRatingName().toString() : null, request.getGatheringName() != null ? request.getGatheringName().toString() : null, request.getNumberOfPlayer() != null ? request.getNumberOfPlayer().toString() : null, request.getKeyId() != null ? request.getKeyId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        BallotDomain domain = this;
        domain.body = result.getBody();
        domain.signature = result.getSignature();
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String ratingName, String gatheringName, String numberOfPlayer, String keyId, String childType) {
        return String.join((CharSequence)":", "matchmaking", namespaceName, userId, ratingName, gatheringName, numberOfPlayer, keyId, childType);
    }

    public static String createCacheKey(String ratingName, String gatheringName, String numberOfPlayer, String keyId) {
        return String.join((CharSequence)":", ratingName, gatheringName, numberOfPlayer, keyId);
    }

    public Ballot model() {
        Ballot value = this.cache.get(this.parentKey, BallotDomain.createCacheKey(this.getRatingName() != null ? this.getRatingName().toString() : null, this.getGatheringName() != null ? this.getGatheringName().toString() : null, this.getNumberOfPlayer() != null ? this.getNumberOfPlayer().toString() : null, this.getKeyId() != null ? this.getKeyId().toString() : null), Ballot.class);
        if (value == null) {
            try {
                this.get(new GetBallotByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, BallotDomain.createCacheKey(this.getRatingName() != null ? this.getRatingName().toString() : null, this.getGatheringName() != null ? this.getGatheringName().toString() : null, this.getNumberOfPlayer() != null ? this.getNumberOfPlayer().toString() : null, this.getKeyId() != null ? this.getKeyId().toString() : null), Ballot.class);
            }
            value = this.cache.get(this.parentKey, BallotDomain.createCacheKey(this.getRatingName() != null ? this.getRatingName().toString() : null, this.getGatheringName() != null ? this.getGatheringName().toString() : null, this.getNumberOfPlayer() != null ? this.getNumberOfPlayer().toString() : null, this.getKeyId() != null ? this.getKeyId().toString() : null), Ballot.class);
        }
        return value;
    }
}

