/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.matchmaking.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.matchmaking.Gs2MatchmakingRestClient;
import io.gs2.matchmaking.domain.model.RatingDomain;
import io.gs2.matchmaking.domain.model.UserDomain;
import io.gs2.matchmaking.model.Rating;
import io.gs2.matchmaking.request.DescribeRatingsByUserIdRequest;
import io.gs2.matchmaking.result.DescribeRatingsByUserIdResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeRatingsByUserIdIterator
implements Iterator<Rating>,
Iterable<Rating> {
    CacheDatabase cache;
    Gs2MatchmakingRestClient client;
    String namespaceName;
    String userId;
    String pageToken;
    boolean last;
    List<Rating> result;
    Integer fetchSize;

    public DescribeRatingsByUserIdIterator(CacheDatabase cache, Gs2MatchmakingRestClient client, String namespaceName, String userId) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Rating>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Rating");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Rating.class)) {
            this.result = this.cache.list(parentKey, Rating.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeRatingsByUserIdResult r = this.client.describeRatingsByUserId(new DescribeRatingsByUserIdRequest().withNamespaceName(this.namespaceName).withUserId(this.userId).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Rating item : this.result) {
                this.cache.put(parentKey, RatingDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Rating.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Rating next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Rating ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Rating> iterator() {
        return this;
    }
}

