/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.matchmaking.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.matchmaking.Gs2MatchmakingRestClient;
import io.gs2.matchmaking.domain.model.NamespaceDomain;
import io.gs2.matchmaking.domain.model.RatingModelDomain;
import io.gs2.matchmaking.model.RatingModel;
import io.gs2.matchmaking.request.DescribeRatingModelsRequest;
import io.gs2.matchmaking.result.DescribeRatingModelsResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeRatingModelsIterator
implements Iterator<RatingModel>,
Iterable<RatingModel> {
    CacheDatabase cache;
    Gs2MatchmakingRestClient client;
    String namespaceName;
    boolean last;
    List<RatingModel> result;
    Integer fetchSize;

    public DescribeRatingModelsIterator(CacheDatabase cache, Gs2MatchmakingRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.last = false;
        this.result = new ArrayList<RatingModel>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "RatingModel");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, RatingModel.class)) {
            this.result = this.cache.list(parentKey, RatingModel.class).stream().collect(Collectors.toList());
            this.last = true;
        } else {
            DescribeRatingModelsResult r = this.client.describeRatingModels(new DescribeRatingModelsRequest().withNamespaceName(this.namespaceName));
            this.result = r.getItems();
            this.last = true;
            for (RatingModel item : this.result) {
                this.cache.put(parentKey, RatingModelDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, RatingModel.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public RatingModel next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        RatingModel ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<RatingModel> iterator() {
        return this;
    }
}

