/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.matchmaking.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.matchmaking.Gs2MatchmakingRestClient;
import io.gs2.matchmaking.domain.model.NamespaceDomain;
import io.gs2.matchmaking.domain.model.RatingModelMasterDomain;
import io.gs2.matchmaking.model.RatingModelMaster;
import io.gs2.matchmaking.request.DescribeRatingModelMastersRequest;
import io.gs2.matchmaking.result.DescribeRatingModelMastersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeRatingModelMastersIterator
implements Iterator<RatingModelMaster>,
Iterable<RatingModelMaster> {
    CacheDatabase cache;
    Gs2MatchmakingRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<RatingModelMaster> result;
    Integer fetchSize;

    public DescribeRatingModelMastersIterator(CacheDatabase cache, Gs2MatchmakingRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<RatingModelMaster>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "RatingModelMaster");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, RatingModelMaster.class)) {
            this.result = this.cache.list(parentKey, RatingModelMaster.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeRatingModelMastersResult r = this.client.describeRatingModelMasters(new DescribeRatingModelMastersRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (RatingModelMaster item : this.result) {
                this.cache.put(parentKey, RatingModelMasterDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, RatingModelMaster.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public RatingModelMaster next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        RatingModelMaster ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<RatingModelMaster> iterator() {
        return this;
    }
}

