/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.matchmaking;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.matchmaking.request.CancelMatchmakingByUserIdRequest;
import io.gs2.matchmaking.request.CancelMatchmakingRequest;
import io.gs2.matchmaking.request.CommitVoteRequest;
import io.gs2.matchmaking.request.CreateGatheringByUserIdRequest;
import io.gs2.matchmaking.request.CreateGatheringRequest;
import io.gs2.matchmaking.request.CreateNamespaceRequest;
import io.gs2.matchmaking.request.CreateRatingModelMasterRequest;
import io.gs2.matchmaking.request.DeleteGatheringRequest;
import io.gs2.matchmaking.request.DeleteNamespaceRequest;
import io.gs2.matchmaking.request.DeleteRatingModelMasterRequest;
import io.gs2.matchmaking.request.DeleteRatingRequest;
import io.gs2.matchmaking.request.DescribeGatheringsRequest;
import io.gs2.matchmaking.request.DescribeNamespacesRequest;
import io.gs2.matchmaking.request.DescribeRatingModelMastersRequest;
import io.gs2.matchmaking.request.DescribeRatingModelsRequest;
import io.gs2.matchmaking.request.DescribeRatingsByUserIdRequest;
import io.gs2.matchmaking.request.DescribeRatingsRequest;
import io.gs2.matchmaking.request.DoMatchmakingByPlayerRequest;
import io.gs2.matchmaking.request.DoMatchmakingByUserIdRequest;
import io.gs2.matchmaking.request.DoMatchmakingRequest;
import io.gs2.matchmaking.request.ExportMasterRequest;
import io.gs2.matchmaking.request.GetBallotByUserIdRequest;
import io.gs2.matchmaking.request.GetBallotRequest;
import io.gs2.matchmaking.request.GetCurrentRatingModelMasterRequest;
import io.gs2.matchmaking.request.GetGatheringRequest;
import io.gs2.matchmaking.request.GetNamespaceRequest;
import io.gs2.matchmaking.request.GetNamespaceStatusRequest;
import io.gs2.matchmaking.request.GetRatingByUserIdRequest;
import io.gs2.matchmaking.request.GetRatingModelMasterRequest;
import io.gs2.matchmaking.request.GetRatingModelRequest;
import io.gs2.matchmaking.request.GetRatingRequest;
import io.gs2.matchmaking.request.PutResultRequest;
import io.gs2.matchmaking.request.UpdateCurrentRatingModelMasterFromGitHubRequest;
import io.gs2.matchmaking.request.UpdateCurrentRatingModelMasterRequest;
import io.gs2.matchmaking.request.UpdateGatheringByUserIdRequest;
import io.gs2.matchmaking.request.UpdateGatheringRequest;
import io.gs2.matchmaking.request.UpdateNamespaceRequest;
import io.gs2.matchmaking.request.UpdateRatingModelMasterRequest;
import io.gs2.matchmaking.request.VoteMultipleRequest;
import io.gs2.matchmaking.request.VoteRequest;
import io.gs2.matchmaking.result.CancelMatchmakingByUserIdResult;
import io.gs2.matchmaking.result.CancelMatchmakingResult;
import io.gs2.matchmaking.result.CommitVoteResult;
import io.gs2.matchmaking.result.CreateGatheringByUserIdResult;
import io.gs2.matchmaking.result.CreateGatheringResult;
import io.gs2.matchmaking.result.CreateNamespaceResult;
import io.gs2.matchmaking.result.CreateRatingModelMasterResult;
import io.gs2.matchmaking.result.DeleteGatheringResult;
import io.gs2.matchmaking.result.DeleteNamespaceResult;
import io.gs2.matchmaking.result.DeleteRatingModelMasterResult;
import io.gs2.matchmaking.result.DeleteRatingResult;
import io.gs2.matchmaking.result.DescribeGatheringsResult;
import io.gs2.matchmaking.result.DescribeNamespacesResult;
import io.gs2.matchmaking.result.DescribeRatingModelMastersResult;
import io.gs2.matchmaking.result.DescribeRatingModelsResult;
import io.gs2.matchmaking.result.DescribeRatingsByUserIdResult;
import io.gs2.matchmaking.result.DescribeRatingsResult;
import io.gs2.matchmaking.result.DoMatchmakingByPlayerResult;
import io.gs2.matchmaking.result.DoMatchmakingByUserIdResult;
import io.gs2.matchmaking.result.DoMatchmakingResult;
import io.gs2.matchmaking.result.ExportMasterResult;
import io.gs2.matchmaking.result.GetBallotByUserIdResult;
import io.gs2.matchmaking.result.GetBallotResult;
import io.gs2.matchmaking.result.GetCurrentRatingModelMasterResult;
import io.gs2.matchmaking.result.GetGatheringResult;
import io.gs2.matchmaking.result.GetNamespaceResult;
import io.gs2.matchmaking.result.GetNamespaceStatusResult;
import io.gs2.matchmaking.result.GetRatingByUserIdResult;
import io.gs2.matchmaking.result.GetRatingModelMasterResult;
import io.gs2.matchmaking.result.GetRatingModelResult;
import io.gs2.matchmaking.result.GetRatingResult;
import io.gs2.matchmaking.result.PutResultResult;
import io.gs2.matchmaking.result.UpdateCurrentRatingModelMasterFromGitHubResult;
import io.gs2.matchmaking.result.UpdateCurrentRatingModelMasterResult;
import io.gs2.matchmaking.result.UpdateGatheringByUserIdResult;
import io.gs2.matchmaking.result.UpdateGatheringResult;
import io.gs2.matchmaking.result.UpdateNamespaceResult;
import io.gs2.matchmaking.result.UpdateRatingModelMasterResult;
import io.gs2.matchmaking.result.VoteMultipleResult;
import io.gs2.matchmaking.result.VoteResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;

public class Gs2MatchmakingRestClient
extends AbstractGs2Client<Gs2MatchmakingRestClient> {
    public Gs2MatchmakingRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void describeGatheringsAsync(DescribeGatheringsRequest request, AsyncAction<AsyncResult<DescribeGatheringsResult>> callback) {
        DescribeGatheringsTask task = new DescribeGatheringsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeGatheringsResult describeGatherings(DescribeGatheringsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeGatheringsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeGatheringsResult)resultAsyncResult[0].getResult();
    }

    public void createGatheringAsync(CreateGatheringRequest request, AsyncAction<AsyncResult<CreateGatheringResult>> callback) {
        CreateGatheringTask task = new CreateGatheringTask(request, callback);
        this.session.execute(task);
    }

    public CreateGatheringResult createGathering(CreateGatheringRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createGatheringAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateGatheringResult)resultAsyncResult[0].getResult();
    }

    public void createGatheringByUserIdAsync(CreateGatheringByUserIdRequest request, AsyncAction<AsyncResult<CreateGatheringByUserIdResult>> callback) {
        CreateGatheringByUserIdTask task = new CreateGatheringByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CreateGatheringByUserIdResult createGatheringByUserId(CreateGatheringByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createGatheringByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateGatheringByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void updateGatheringAsync(UpdateGatheringRequest request, AsyncAction<AsyncResult<UpdateGatheringResult>> callback) {
        UpdateGatheringTask task = new UpdateGatheringTask(request, callback);
        this.session.execute(task);
    }

    public UpdateGatheringResult updateGathering(UpdateGatheringRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateGatheringAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateGatheringResult)resultAsyncResult[0].getResult();
    }

    public void updateGatheringByUserIdAsync(UpdateGatheringByUserIdRequest request, AsyncAction<AsyncResult<UpdateGatheringByUserIdResult>> callback) {
        UpdateGatheringByUserIdTask task = new UpdateGatheringByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public UpdateGatheringByUserIdResult updateGatheringByUserId(UpdateGatheringByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateGatheringByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateGatheringByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void doMatchmakingByPlayerAsync(DoMatchmakingByPlayerRequest request, AsyncAction<AsyncResult<DoMatchmakingByPlayerResult>> callback) {
        DoMatchmakingByPlayerTask task = new DoMatchmakingByPlayerTask(request, callback);
        this.session.execute(task);
    }

    public DoMatchmakingByPlayerResult doMatchmakingByPlayer(DoMatchmakingByPlayerRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.doMatchmakingByPlayerAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DoMatchmakingByPlayerResult)resultAsyncResult[0].getResult();
    }

    public void doMatchmakingAsync(DoMatchmakingRequest request, AsyncAction<AsyncResult<DoMatchmakingResult>> callback) {
        DoMatchmakingTask task = new DoMatchmakingTask(request, callback);
        this.session.execute(task);
    }

    public DoMatchmakingResult doMatchmaking(DoMatchmakingRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.doMatchmakingAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DoMatchmakingResult)resultAsyncResult[0].getResult();
    }

    public void doMatchmakingByUserIdAsync(DoMatchmakingByUserIdRequest request, AsyncAction<AsyncResult<DoMatchmakingByUserIdResult>> callback) {
        DoMatchmakingByUserIdTask task = new DoMatchmakingByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DoMatchmakingByUserIdResult doMatchmakingByUserId(DoMatchmakingByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.doMatchmakingByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DoMatchmakingByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getGatheringAsync(GetGatheringRequest request, AsyncAction<AsyncResult<GetGatheringResult>> callback) {
        GetGatheringTask task = new GetGatheringTask(request, callback);
        this.session.execute(task);
    }

    public GetGatheringResult getGathering(GetGatheringRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getGatheringAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetGatheringResult)resultAsyncResult[0].getResult();
    }

    public void cancelMatchmakingAsync(CancelMatchmakingRequest request, AsyncAction<AsyncResult<CancelMatchmakingResult>> callback) {
        CancelMatchmakingTask task = new CancelMatchmakingTask(request, callback);
        this.session.execute(task);
    }

    public CancelMatchmakingResult cancelMatchmaking(CancelMatchmakingRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.cancelMatchmakingAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CancelMatchmakingResult)resultAsyncResult[0].getResult();
    }

    public void cancelMatchmakingByUserIdAsync(CancelMatchmakingByUserIdRequest request, AsyncAction<AsyncResult<CancelMatchmakingByUserIdResult>> callback) {
        CancelMatchmakingByUserIdTask task = new CancelMatchmakingByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CancelMatchmakingByUserIdResult cancelMatchmakingByUserId(CancelMatchmakingByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.cancelMatchmakingByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CancelMatchmakingByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void deleteGatheringAsync(DeleteGatheringRequest request, AsyncAction<AsyncResult<DeleteGatheringResult>> callback) {
        DeleteGatheringTask task = new DeleteGatheringTask(request, callback);
        this.session.execute(task);
    }

    public DeleteGatheringResult deleteGathering(DeleteGatheringRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteGatheringAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteGatheringResult)resultAsyncResult[0].getResult();
    }

    public void describeRatingModelMastersAsync(DescribeRatingModelMastersRequest request, AsyncAction<AsyncResult<DescribeRatingModelMastersResult>> callback) {
        DescribeRatingModelMastersTask task = new DescribeRatingModelMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeRatingModelMastersResult describeRatingModelMasters(DescribeRatingModelMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeRatingModelMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeRatingModelMastersResult)resultAsyncResult[0].getResult();
    }

    public void createRatingModelMasterAsync(CreateRatingModelMasterRequest request, AsyncAction<AsyncResult<CreateRatingModelMasterResult>> callback) {
        CreateRatingModelMasterTask task = new CreateRatingModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreateRatingModelMasterResult createRatingModelMaster(CreateRatingModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createRatingModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateRatingModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void getRatingModelMasterAsync(GetRatingModelMasterRequest request, AsyncAction<AsyncResult<GetRatingModelMasterResult>> callback) {
        GetRatingModelMasterTask task = new GetRatingModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetRatingModelMasterResult getRatingModelMaster(GetRatingModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getRatingModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetRatingModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateRatingModelMasterAsync(UpdateRatingModelMasterRequest request, AsyncAction<AsyncResult<UpdateRatingModelMasterResult>> callback) {
        UpdateRatingModelMasterTask task = new UpdateRatingModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateRatingModelMasterResult updateRatingModelMaster(UpdateRatingModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateRatingModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateRatingModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteRatingModelMasterAsync(DeleteRatingModelMasterRequest request, AsyncAction<AsyncResult<DeleteRatingModelMasterResult>> callback) {
        DeleteRatingModelMasterTask task = new DeleteRatingModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeleteRatingModelMasterResult deleteRatingModelMaster(DeleteRatingModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteRatingModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteRatingModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void describeRatingModelsAsync(DescribeRatingModelsRequest request, AsyncAction<AsyncResult<DescribeRatingModelsResult>> callback) {
        DescribeRatingModelsTask task = new DescribeRatingModelsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeRatingModelsResult describeRatingModels(DescribeRatingModelsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeRatingModelsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeRatingModelsResult)resultAsyncResult[0].getResult();
    }

    public void getRatingModelAsync(GetRatingModelRequest request, AsyncAction<AsyncResult<GetRatingModelResult>> callback) {
        GetRatingModelTask task = new GetRatingModelTask(request, callback);
        this.session.execute(task);
    }

    public GetRatingModelResult getRatingModel(GetRatingModelRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getRatingModelAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetRatingModelResult)resultAsyncResult[0].getResult();
    }

    public void exportMasterAsync(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> callback) {
        ExportMasterTask task = new ExportMasterTask(request, callback);
        this.session.execute(task);
    }

    public ExportMasterResult exportMaster(ExportMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.exportMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ExportMasterResult)resultAsyncResult[0].getResult();
    }

    public void getCurrentRatingModelMasterAsync(GetCurrentRatingModelMasterRequest request, AsyncAction<AsyncResult<GetCurrentRatingModelMasterResult>> callback) {
        GetCurrentRatingModelMasterTask task = new GetCurrentRatingModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetCurrentRatingModelMasterResult getCurrentRatingModelMaster(GetCurrentRatingModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCurrentRatingModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCurrentRatingModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentRatingModelMasterAsync(UpdateCurrentRatingModelMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentRatingModelMasterResult>> callback) {
        UpdateCurrentRatingModelMasterTask task = new UpdateCurrentRatingModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentRatingModelMasterResult updateCurrentRatingModelMaster(UpdateCurrentRatingModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentRatingModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentRatingModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentRatingModelMasterFromGitHubAsync(UpdateCurrentRatingModelMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentRatingModelMasterFromGitHubResult>> callback) {
        UpdateCurrentRatingModelMasterFromGitHubTask task = new UpdateCurrentRatingModelMasterFromGitHubTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentRatingModelMasterFromGitHubResult updateCurrentRatingModelMasterFromGitHub(UpdateCurrentRatingModelMasterFromGitHubRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentRatingModelMasterFromGitHubAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentRatingModelMasterFromGitHubResult)resultAsyncResult[0].getResult();
    }

    public void describeRatingsAsync(DescribeRatingsRequest request, AsyncAction<AsyncResult<DescribeRatingsResult>> callback) {
        DescribeRatingsTask task = new DescribeRatingsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeRatingsResult describeRatings(DescribeRatingsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeRatingsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeRatingsResult)resultAsyncResult[0].getResult();
    }

    public void describeRatingsByUserIdAsync(DescribeRatingsByUserIdRequest request, AsyncAction<AsyncResult<DescribeRatingsByUserIdResult>> callback) {
        DescribeRatingsByUserIdTask task = new DescribeRatingsByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeRatingsByUserIdResult describeRatingsByUserId(DescribeRatingsByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeRatingsByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeRatingsByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getRatingAsync(GetRatingRequest request, AsyncAction<AsyncResult<GetRatingResult>> callback) {
        GetRatingTask task = new GetRatingTask(request, callback);
        this.session.execute(task);
    }

    public GetRatingResult getRating(GetRatingRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getRatingAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetRatingResult)resultAsyncResult[0].getResult();
    }

    public void getRatingByUserIdAsync(GetRatingByUserIdRequest request, AsyncAction<AsyncResult<GetRatingByUserIdResult>> callback) {
        GetRatingByUserIdTask task = new GetRatingByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetRatingByUserIdResult getRatingByUserId(GetRatingByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getRatingByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetRatingByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void putResultAsync(PutResultRequest request, AsyncAction<AsyncResult<PutResultResult>> callback) {
        PutResultTask task = new PutResultTask(request, callback);
        this.session.execute(task);
    }

    public PutResultResult putResult(PutResultRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.putResultAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PutResultResult)resultAsyncResult[0].getResult();
    }

    public void deleteRatingAsync(DeleteRatingRequest request, AsyncAction<AsyncResult<DeleteRatingResult>> callback) {
        DeleteRatingTask task = new DeleteRatingTask(request, callback);
        this.session.execute(task);
    }

    public DeleteRatingResult deleteRating(DeleteRatingRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteRatingAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteRatingResult)resultAsyncResult[0].getResult();
    }

    public void getBallotAsync(GetBallotRequest request, AsyncAction<AsyncResult<GetBallotResult>> callback) {
        GetBallotTask task = new GetBallotTask(request, callback);
        this.session.execute(task);
    }

    public GetBallotResult getBallot(GetBallotRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getBallotAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetBallotResult)resultAsyncResult[0].getResult();
    }

    public void getBallotByUserIdAsync(GetBallotByUserIdRequest request, AsyncAction<AsyncResult<GetBallotByUserIdResult>> callback) {
        GetBallotByUserIdTask task = new GetBallotByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetBallotByUserIdResult getBallotByUserId(GetBallotByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getBallotByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetBallotByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void voteAsync(VoteRequest request, AsyncAction<AsyncResult<VoteResult>> callback) {
        VoteTask task = new VoteTask(request, callback);
        this.session.execute(task);
    }

    public VoteResult vote(VoteRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.voteAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (VoteResult)resultAsyncResult[0].getResult();
    }

    public void voteMultipleAsync(VoteMultipleRequest request, AsyncAction<AsyncResult<VoteMultipleResult>> callback) {
        VoteMultipleTask task = new VoteMultipleTask(request, callback);
        this.session.execute(task);
    }

    public VoteMultipleResult voteMultiple(VoteMultipleRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.voteMultipleAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (VoteMultipleResult)resultAsyncResult[0].getResult();
    }

    public void commitVoteAsync(CommitVoteRequest request, AsyncAction<AsyncResult<CommitVoteResult>> callback) {
        CommitVoteTask task = new CommitVoteTask(request, callback);
        this.session.execute(task);
    }

    public CommitVoteResult commitVote(CommitVoteRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.commitVoteAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CommitVoteResult)resultAsyncResult[0].getResult();
    }

    class CommitVoteTask
    extends Gs2RestSessionTask<CommitVoteResult> {
        private CommitVoteRequest request;

        public CommitVoteTask(CommitVoteRequest request, AsyncAction<AsyncResult<CommitVoteResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CommitVoteResult parse(JsonNode data) {
            return CommitVoteResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/vote/{ratingName}/{gatheringName}/action/vote/commit";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{ratingName}", this.request.getRatingName() == null || this.request.getRatingName().length() == 0 ? "null" : String.valueOf(this.request.getRatingName()));
            url = url.replace("{gatheringName}", this.request.getGatheringName() == null || this.request.getGatheringName().length() == 0 ? "null" : String.valueOf(this.request.getGatheringName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", CommitVoteTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class VoteMultipleTask
    extends Gs2RestSessionTask<VoteMultipleResult> {
        private VoteMultipleRequest request;

        public VoteMultipleTask(VoteMultipleRequest request, AsyncAction<AsyncResult<VoteMultipleResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public VoteMultipleResult parse(JsonNode data) {
            return VoteMultipleResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/action/vote/multiple";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("signedBallots", VoteMultipleTask.this.request.getSignedBallots() == null ? new ArrayList() : VoteMultipleTask.this.request.getSignedBallots().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("gameResults", VoteMultipleTask.this.request.getGameResults() == null ? new ArrayList() : VoteMultipleTask.this.request.getGameResults().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("keyId", VoteMultipleTask.this.request.getKeyId());
                    this.put("contextStack", VoteMultipleTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class VoteTask
    extends Gs2RestSessionTask<VoteResult> {
        private VoteRequest request;

        public VoteTask(VoteRequest request, AsyncAction<AsyncResult<VoteResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public VoteResult parse(JsonNode data) {
            return VoteResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/action/vote";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("ballotBody", VoteTask.this.request.getBallotBody());
                    this.put("ballotSignature", VoteTask.this.request.getBallotSignature());
                    this.put("gameResults", VoteTask.this.request.getGameResults() == null ? new ArrayList() : VoteTask.this.request.getGameResults().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("keyId", VoteTask.this.request.getKeyId());
                    this.put("contextStack", VoteTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetBallotByUserIdTask
    extends Gs2RestSessionTask<GetBallotByUserIdResult> {
        private GetBallotByUserIdRequest request;

        public GetBallotByUserIdTask(GetBallotByUserIdRequest request, AsyncAction<AsyncResult<GetBallotByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetBallotByUserIdResult parse(JsonNode data) {
            return GetBallotByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/vote/{ratingName}/{gatheringName}/ballot";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{ratingName}", this.request.getRatingName() == null || this.request.getRatingName().length() == 0 ? "null" : String.valueOf(this.request.getRatingName()));
            url = url.replace("{gatheringName}", this.request.getGatheringName() == null || this.request.getGatheringName().length() == 0 ? "null" : String.valueOf(this.request.getGatheringName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("numberOfPlayer", GetBallotByUserIdTask.this.request.getNumberOfPlayer());
                    this.put("keyId", GetBallotByUserIdTask.this.request.getKeyId());
                    this.put("contextStack", GetBallotByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetBallotTask
    extends Gs2RestSessionTask<GetBallotResult> {
        private GetBallotRequest request;

        public GetBallotTask(GetBallotRequest request, AsyncAction<AsyncResult<GetBallotResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetBallotResult parse(JsonNode data) {
            return GetBallotResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/vote/{ratingName}/{gatheringName}/ballot";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{ratingName}", this.request.getRatingName() == null || this.request.getRatingName().length() == 0 ? "null" : String.valueOf(this.request.getRatingName()));
            url = url.replace("{gatheringName}", this.request.getGatheringName() == null || this.request.getGatheringName().length() == 0 ? "null" : String.valueOf(this.request.getGatheringName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("numberOfPlayer", GetBallotTask.this.request.getNumberOfPlayer());
                    this.put("keyId", GetBallotTask.this.request.getKeyId());
                    this.put("contextStack", GetBallotTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DeleteRatingTask
    extends Gs2RestSessionTask<DeleteRatingResult> {
        private DeleteRatingRequest request;

        public DeleteRatingTask(DeleteRatingRequest request, AsyncAction<AsyncResult<DeleteRatingResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteRatingResult parse(JsonNode data) {
            return DeleteRatingResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/rating/{ratingName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{ratingName}", this.request.getRatingName() == null || this.request.getRatingName().length() == 0 ? "null" : String.valueOf(this.request.getRatingName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class PutResultTask
    extends Gs2RestSessionTask<PutResultResult> {
        private PutResultRequest request;

        public PutResultTask(PutResultRequest request, AsyncAction<AsyncResult<PutResultResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PutResultResult parse(JsonNode data) {
            return PutResultResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/rating/{ratingName}/vote";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{ratingName}", this.request.getRatingName() == null || this.request.getRatingName().length() == 0 ? "null" : String.valueOf(this.request.getRatingName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("gameResults", PutResultTask.this.request.getGameResults() == null ? new ArrayList() : PutResultTask.this.request.getGameResults().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", PutResultTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetRatingByUserIdTask
    extends Gs2RestSessionTask<GetRatingByUserIdResult> {
        private GetRatingByUserIdRequest request;

        public GetRatingByUserIdTask(GetRatingByUserIdRequest request, AsyncAction<AsyncResult<GetRatingByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetRatingByUserIdResult parse(JsonNode data) {
            return GetRatingByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/rating/{ratingName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{ratingName}", this.request.getRatingName() == null || this.request.getRatingName().length() == 0 ? "null" : String.valueOf(this.request.getRatingName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetRatingTask
    extends Gs2RestSessionTask<GetRatingResult> {
        private GetRatingRequest request;

        public GetRatingTask(GetRatingRequest request, AsyncAction<AsyncResult<GetRatingResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetRatingResult parse(JsonNode data) {
            return GetRatingResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/rating/{ratingName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{ratingName}", this.request.getRatingName() == null || this.request.getRatingName().length() == 0 ? "null" : String.valueOf(this.request.getRatingName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeRatingsByUserIdTask
    extends Gs2RestSessionTask<DescribeRatingsByUserIdResult> {
        private DescribeRatingsByUserIdRequest request;

        public DescribeRatingsByUserIdTask(DescribeRatingsByUserIdRequest request, AsyncAction<AsyncResult<DescribeRatingsByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeRatingsByUserIdResult parse(JsonNode data) {
            return DescribeRatingsByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/rating";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeRatingsTask
    extends Gs2RestSessionTask<DescribeRatingsResult> {
        private DescribeRatingsRequest request;

        public DescribeRatingsTask(DescribeRatingsRequest request, AsyncAction<AsyncResult<DescribeRatingsResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeRatingsResult parse(JsonNode data) {
            return DescribeRatingsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/rating";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentRatingModelMasterFromGitHubTask
    extends Gs2RestSessionTask<UpdateCurrentRatingModelMasterFromGitHubResult> {
        private UpdateCurrentRatingModelMasterFromGitHubRequest request;

        public UpdateCurrentRatingModelMasterFromGitHubTask(UpdateCurrentRatingModelMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentRatingModelMasterFromGitHubResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentRatingModelMasterFromGitHubResult parse(JsonNode data) {
            return UpdateCurrentRatingModelMasterFromGitHubResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/from_git_hub";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("checkoutSetting", UpdateCurrentRatingModelMasterFromGitHubTask.this.request.getCheckoutSetting() != null ? UpdateCurrentRatingModelMasterFromGitHubTask.this.request.getCheckoutSetting().toJson() : null);
                    this.put("contextStack", UpdateCurrentRatingModelMasterFromGitHubTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentRatingModelMasterTask
    extends Gs2RestSessionTask<UpdateCurrentRatingModelMasterResult> {
        private UpdateCurrentRatingModelMasterRequest request;

        public UpdateCurrentRatingModelMasterTask(UpdateCurrentRatingModelMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentRatingModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentRatingModelMasterResult parse(JsonNode data) {
            return UpdateCurrentRatingModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("settings", UpdateCurrentRatingModelMasterTask.this.request.getSettings());
                    this.put("contextStack", UpdateCurrentRatingModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCurrentRatingModelMasterTask
    extends Gs2RestSessionTask<GetCurrentRatingModelMasterResult> {
        private GetCurrentRatingModelMasterRequest request;

        public GetCurrentRatingModelMasterTask(GetCurrentRatingModelMasterRequest request, AsyncAction<AsyncResult<GetCurrentRatingModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCurrentRatingModelMasterResult parse(JsonNode data) {
            return GetCurrentRatingModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ExportMasterTask
    extends Gs2RestSessionTask<ExportMasterResult> {
        private ExportMasterRequest request;

        public ExportMasterTask(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ExportMasterResult parse(JsonNode data) {
            return ExportMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/export";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetRatingModelTask
    extends Gs2RestSessionTask<GetRatingModelResult> {
        private GetRatingModelRequest request;

        public GetRatingModelTask(GetRatingModelRequest request, AsyncAction<AsyncResult<GetRatingModelResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetRatingModelResult parse(JsonNode data) {
            return GetRatingModelResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/rating/{ratingName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{ratingName}", this.request.getRatingName() == null || this.request.getRatingName().length() == 0 ? "null" : String.valueOf(this.request.getRatingName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeRatingModelsTask
    extends Gs2RestSessionTask<DescribeRatingModelsResult> {
        private DescribeRatingModelsRequest request;

        public DescribeRatingModelsTask(DescribeRatingModelsRequest request, AsyncAction<AsyncResult<DescribeRatingModelsResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeRatingModelsResult parse(JsonNode data) {
            return DescribeRatingModelsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/rating";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteRatingModelMasterTask
    extends Gs2RestSessionTask<DeleteRatingModelMasterResult> {
        private DeleteRatingModelMasterRequest request;

        public DeleteRatingModelMasterTask(DeleteRatingModelMasterRequest request, AsyncAction<AsyncResult<DeleteRatingModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteRatingModelMasterResult parse(JsonNode data) {
            return DeleteRatingModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/rating/{ratingName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{ratingName}", this.request.getRatingName() == null || this.request.getRatingName().length() == 0 ? "null" : String.valueOf(this.request.getRatingName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateRatingModelMasterTask
    extends Gs2RestSessionTask<UpdateRatingModelMasterResult> {
        private UpdateRatingModelMasterRequest request;

        public UpdateRatingModelMasterTask(UpdateRatingModelMasterRequest request, AsyncAction<AsyncResult<UpdateRatingModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateRatingModelMasterResult parse(JsonNode data) {
            return UpdateRatingModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/rating/{ratingName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{ratingName}", this.request.getRatingName() == null || this.request.getRatingName().length() == 0 ? "null" : String.valueOf(this.request.getRatingName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateRatingModelMasterTask.this.request.getDescription());
                    this.put("metadata", UpdateRatingModelMasterTask.this.request.getMetadata());
                    this.put("volatility", UpdateRatingModelMasterTask.this.request.getVolatility());
                    this.put("contextStack", UpdateRatingModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetRatingModelMasterTask
    extends Gs2RestSessionTask<GetRatingModelMasterResult> {
        private GetRatingModelMasterRequest request;

        public GetRatingModelMasterTask(GetRatingModelMasterRequest request, AsyncAction<AsyncResult<GetRatingModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetRatingModelMasterResult parse(JsonNode data) {
            return GetRatingModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/rating/{ratingName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{ratingName}", this.request.getRatingName() == null || this.request.getRatingName().length() == 0 ? "null" : String.valueOf(this.request.getRatingName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateRatingModelMasterTask
    extends Gs2RestSessionTask<CreateRatingModelMasterResult> {
        private CreateRatingModelMasterRequest request;

        public CreateRatingModelMasterTask(CreateRatingModelMasterRequest request, AsyncAction<AsyncResult<CreateRatingModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateRatingModelMasterResult parse(JsonNode data) {
            return CreateRatingModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/rating";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateRatingModelMasterTask.this.request.getName());
                    this.put("description", CreateRatingModelMasterTask.this.request.getDescription());
                    this.put("metadata", CreateRatingModelMasterTask.this.request.getMetadata());
                    this.put("volatility", CreateRatingModelMasterTask.this.request.getVolatility());
                    this.put("contextStack", CreateRatingModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeRatingModelMastersTask
    extends Gs2RestSessionTask<DescribeRatingModelMastersResult> {
        private DescribeRatingModelMastersRequest request;

        public DescribeRatingModelMastersTask(DescribeRatingModelMastersRequest request, AsyncAction<AsyncResult<DescribeRatingModelMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeRatingModelMastersResult parse(JsonNode data) {
            return DescribeRatingModelMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/rating";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteGatheringTask
    extends Gs2RestSessionTask<DeleteGatheringResult> {
        private DeleteGatheringRequest request;

        public DeleteGatheringTask(DeleteGatheringRequest request, AsyncAction<AsyncResult<DeleteGatheringResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteGatheringResult parse(JsonNode data) {
            return DeleteGatheringResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/gathering/{gatheringName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{gatheringName}", this.request.getGatheringName() == null || this.request.getGatheringName().length() == 0 ? "null" : String.valueOf(this.request.getGatheringName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CancelMatchmakingByUserIdTask
    extends Gs2RestSessionTask<CancelMatchmakingByUserIdResult> {
        private CancelMatchmakingByUserIdRequest request;

        public CancelMatchmakingByUserIdTask(CancelMatchmakingByUserIdRequest request, AsyncAction<AsyncResult<CancelMatchmakingByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CancelMatchmakingByUserIdResult parse(JsonNode data) {
            return CancelMatchmakingByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/gathering/{gatheringName}/user/{userId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{gatheringName}", this.request.getGatheringName() == null || this.request.getGatheringName().length() == 0 ? "null" : String.valueOf(this.request.getGatheringName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CancelMatchmakingTask
    extends Gs2RestSessionTask<CancelMatchmakingResult> {
        private CancelMatchmakingRequest request;

        public CancelMatchmakingTask(CancelMatchmakingRequest request, AsyncAction<AsyncResult<CancelMatchmakingResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CancelMatchmakingResult parse(JsonNode data) {
            return CancelMatchmakingResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/gathering/{gatheringName}/user/me";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{gatheringName}", this.request.getGatheringName() == null || this.request.getGatheringName().length() == 0 ? "null" : String.valueOf(this.request.getGatheringName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetGatheringTask
    extends Gs2RestSessionTask<GetGatheringResult> {
        private GetGatheringRequest request;

        public GetGatheringTask(GetGatheringRequest request, AsyncAction<AsyncResult<GetGatheringResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetGatheringResult parse(JsonNode data) {
            return GetGatheringResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/gathering/{gatheringName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{gatheringName}", this.request.getGatheringName() == null || this.request.getGatheringName().length() == 0 ? "null" : String.valueOf(this.request.getGatheringName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DoMatchmakingByUserIdTask
    extends Gs2RestSessionTask<DoMatchmakingByUserIdResult> {
        private DoMatchmakingByUserIdRequest request;

        public DoMatchmakingByUserIdTask(DoMatchmakingByUserIdRequest request, AsyncAction<AsyncResult<DoMatchmakingByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DoMatchmakingByUserIdResult parse(JsonNode data) {
            return DoMatchmakingByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/gathering/do";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("player", DoMatchmakingByUserIdTask.this.request.getPlayer() != null ? DoMatchmakingByUserIdTask.this.request.getPlayer().toJson() : null);
                    this.put("matchmakingContextToken", DoMatchmakingByUserIdTask.this.request.getMatchmakingContextToken());
                    this.put("contextStack", DoMatchmakingByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DoMatchmakingTask
    extends Gs2RestSessionTask<DoMatchmakingResult> {
        private DoMatchmakingRequest request;

        public DoMatchmakingTask(DoMatchmakingRequest request, AsyncAction<AsyncResult<DoMatchmakingResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DoMatchmakingResult parse(JsonNode data) {
            return DoMatchmakingResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/gathering/do";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("player", DoMatchmakingTask.this.request.getPlayer() != null ? DoMatchmakingTask.this.request.getPlayer().toJson() : null);
                    this.put("matchmakingContextToken", DoMatchmakingTask.this.request.getMatchmakingContextToken());
                    this.put("contextStack", DoMatchmakingTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DoMatchmakingByPlayerTask
    extends Gs2RestSessionTask<DoMatchmakingByPlayerResult> {
        private DoMatchmakingByPlayerRequest request;

        public DoMatchmakingByPlayerTask(DoMatchmakingByPlayerRequest request, AsyncAction<AsyncResult<DoMatchmakingByPlayerResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DoMatchmakingByPlayerResult parse(JsonNode data) {
            return DoMatchmakingByPlayerResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/gathering/player/do";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("player", DoMatchmakingByPlayerTask.this.request.getPlayer() != null ? DoMatchmakingByPlayerTask.this.request.getPlayer().toJson() : null);
                    this.put("matchmakingContextToken", DoMatchmakingByPlayerTask.this.request.getMatchmakingContextToken());
                    this.put("contextStack", DoMatchmakingByPlayerTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateGatheringByUserIdTask
    extends Gs2RestSessionTask<UpdateGatheringByUserIdResult> {
        private UpdateGatheringByUserIdRequest request;

        public UpdateGatheringByUserIdTask(UpdateGatheringByUserIdRequest request, AsyncAction<AsyncResult<UpdateGatheringByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateGatheringByUserIdResult parse(JsonNode data) {
            return UpdateGatheringByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/gathering/{gatheringName}/user/{userId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{gatheringName}", this.request.getGatheringName() == null || this.request.getGatheringName().length() == 0 ? "null" : String.valueOf(this.request.getGatheringName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("attributeRanges", UpdateGatheringByUserIdTask.this.request.getAttributeRanges() == null ? new ArrayList() : UpdateGatheringByUserIdTask.this.request.getAttributeRanges().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", UpdateGatheringByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateGatheringTask
    extends Gs2RestSessionTask<UpdateGatheringResult> {
        private UpdateGatheringRequest request;

        public UpdateGatheringTask(UpdateGatheringRequest request, AsyncAction<AsyncResult<UpdateGatheringResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateGatheringResult parse(JsonNode data) {
            return UpdateGatheringResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/gathering/{gatheringName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{gatheringName}", this.request.getGatheringName() == null || this.request.getGatheringName().length() == 0 ? "null" : String.valueOf(this.request.getGatheringName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("attributeRanges", UpdateGatheringTask.this.request.getAttributeRanges() == null ? new ArrayList() : UpdateGatheringTask.this.request.getAttributeRanges().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", UpdateGatheringTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class CreateGatheringByUserIdTask
    extends Gs2RestSessionTask<CreateGatheringByUserIdResult> {
        private CreateGatheringByUserIdRequest request;

        public CreateGatheringByUserIdTask(CreateGatheringByUserIdRequest request, AsyncAction<AsyncResult<CreateGatheringByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateGatheringByUserIdResult parse(JsonNode data) {
            return CreateGatheringByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/gathering/user/{userId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("player", CreateGatheringByUserIdTask.this.request.getPlayer() != null ? CreateGatheringByUserIdTask.this.request.getPlayer().toJson() : null);
                    this.put("attributeRanges", CreateGatheringByUserIdTask.this.request.getAttributeRanges() == null ? new ArrayList() : CreateGatheringByUserIdTask.this.request.getAttributeRanges().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("capacityOfRoles", CreateGatheringByUserIdTask.this.request.getCapacityOfRoles() == null ? new ArrayList() : CreateGatheringByUserIdTask.this.request.getCapacityOfRoles().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("allowUserIds", CreateGatheringByUserIdTask.this.request.getAllowUserIds() == null ? new ArrayList() : CreateGatheringByUserIdTask.this.request.getAllowUserIds().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("expiresAt", CreateGatheringByUserIdTask.this.request.getExpiresAt());
                    this.put("expiresAtTimeSpan", CreateGatheringByUserIdTask.this.request.getExpiresAtTimeSpan() != null ? CreateGatheringByUserIdTask.this.request.getExpiresAtTimeSpan().toJson() : null);
                    this.put("contextStack", CreateGatheringByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateGatheringTask
    extends Gs2RestSessionTask<CreateGatheringResult> {
        private CreateGatheringRequest request;

        public CreateGatheringTask(CreateGatheringRequest request, AsyncAction<AsyncResult<CreateGatheringResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateGatheringResult parse(JsonNode data) {
            return CreateGatheringResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/gathering";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("player", CreateGatheringTask.this.request.getPlayer() != null ? CreateGatheringTask.this.request.getPlayer().toJson() : null);
                    this.put("attributeRanges", CreateGatheringTask.this.request.getAttributeRanges() == null ? new ArrayList() : CreateGatheringTask.this.request.getAttributeRanges().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("capacityOfRoles", CreateGatheringTask.this.request.getCapacityOfRoles() == null ? new ArrayList() : CreateGatheringTask.this.request.getCapacityOfRoles().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("allowUserIds", CreateGatheringTask.this.request.getAllowUserIds() == null ? new ArrayList() : CreateGatheringTask.this.request.getAllowUserIds().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("expiresAt", CreateGatheringTask.this.request.getExpiresAt());
                    this.put("expiresAtTimeSpan", CreateGatheringTask.this.request.getExpiresAtTimeSpan() != null ? CreateGatheringTask.this.request.getExpiresAtTimeSpan().toJson() : null);
                    this.put("contextStack", CreateGatheringTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeGatheringsTask
    extends Gs2RestSessionTask<DescribeGatheringsResult> {
        private DescribeGatheringsRequest request;

        public DescribeGatheringsTask(DescribeGatheringsRequest request, AsyncAction<AsyncResult<DescribeGatheringsResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeGatheringsResult parse(JsonNode data) {
            return DescribeGatheringsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/gathering";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("enableRating", UpdateNamespaceTask.this.request.getEnableRating());
                    this.put("createGatheringTriggerType", UpdateNamespaceTask.this.request.getCreateGatheringTriggerType());
                    this.put("createGatheringTriggerRealtimeNamespaceId", UpdateNamespaceTask.this.request.getCreateGatheringTriggerRealtimeNamespaceId());
                    this.put("createGatheringTriggerScriptId", UpdateNamespaceTask.this.request.getCreateGatheringTriggerScriptId());
                    this.put("completeMatchmakingTriggerType", UpdateNamespaceTask.this.request.getCompleteMatchmakingTriggerType());
                    this.put("completeMatchmakingTriggerRealtimeNamespaceId", UpdateNamespaceTask.this.request.getCompleteMatchmakingTriggerRealtimeNamespaceId());
                    this.put("completeMatchmakingTriggerScriptId", UpdateNamespaceTask.this.request.getCompleteMatchmakingTriggerScriptId());
                    this.put("joinNotification", UpdateNamespaceTask.this.request.getJoinNotification() != null ? UpdateNamespaceTask.this.request.getJoinNotification().toJson() : null);
                    this.put("leaveNotification", UpdateNamespaceTask.this.request.getLeaveNotification() != null ? UpdateNamespaceTask.this.request.getLeaveNotification().toJson() : null);
                    this.put("completeNotification", UpdateNamespaceTask.this.request.getCompleteNotification() != null ? UpdateNamespaceTask.this.request.getCompleteNotification().toJson() : null);
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("enableRating", CreateNamespaceTask.this.request.getEnableRating());
                    this.put("createGatheringTriggerType", CreateNamespaceTask.this.request.getCreateGatheringTriggerType());
                    this.put("createGatheringTriggerRealtimeNamespaceId", CreateNamespaceTask.this.request.getCreateGatheringTriggerRealtimeNamespaceId());
                    this.put("createGatheringTriggerScriptId", CreateNamespaceTask.this.request.getCreateGatheringTriggerScriptId());
                    this.put("completeMatchmakingTriggerType", CreateNamespaceTask.this.request.getCompleteMatchmakingTriggerType());
                    this.put("completeMatchmakingTriggerRealtimeNamespaceId", CreateNamespaceTask.this.request.getCompleteMatchmakingTriggerRealtimeNamespaceId());
                    this.put("completeMatchmakingTriggerScriptId", CreateNamespaceTask.this.request.getCompleteMatchmakingTriggerScriptId());
                    this.put("joinNotification", CreateNamespaceTask.this.request.getJoinNotification() != null ? CreateNamespaceTask.this.request.getJoinNotification().toJson() : null);
                    this.put("leaveNotification", CreateNamespaceTask.this.request.getLeaveNotification() != null ? CreateNamespaceTask.this.request.getLeaveNotification().toJson() : null);
                    this.put("completeNotification", CreateNamespaceTask.this.request.getCompleteNotification() != null ? CreateNamespaceTask.this.request.getCompleteNotification().toJson() : null);
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2MatchmakingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "matchmaking").replace("{region}", Gs2MatchmakingRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

