/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.lottery.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.lottery.Gs2LotteryRestClient;
import io.gs2.lottery.domain.model.NamespaceDomain;
import io.gs2.lottery.model.LotteryModel;
import io.gs2.lottery.request.GetLotteryModelRequest;
import io.gs2.lottery.result.GetLotteryModelResult;

public class LotteryModelDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2LotteryRestClient client;
    private final String namespaceName;
    private final String lotteryName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getLotteryName() {
        return this.lotteryName;
    }

    public LotteryModelDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String lotteryName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2LotteryRestClient(session);
        this.namespaceName = namespaceName;
        this.lotteryName = lotteryName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "LotteryModel");
    }

    private LotteryModel get(GetLotteryModelRequest request) {
        request.withNamespaceName(this.namespaceName).withLotteryName(this.lotteryName);
        GetLotteryModelResult result = this.client.getLotteryModel(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, LotteryModelDomain.createCacheKey(request.getLotteryName() != null ? request.getLotteryName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public static String createCacheParentKey(String namespaceName, String lotteryName, String childType) {
        return String.join((CharSequence)":", "lottery", namespaceName, lotteryName, childType);
    }

    public static String createCacheKey(String lotteryName) {
        return String.join((CharSequence)":", lotteryName);
    }

    public LotteryModel model() {
        LotteryModel value = this.cache.get(this.parentKey, LotteryModelDomain.createCacheKey(this.getLotteryName() != null ? this.getLotteryName().toString() : null), LotteryModel.class);
        if (value == null) {
            try {
                this.get(new GetLotteryModelRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, LotteryModelDomain.createCacheKey(this.getLotteryName() != null ? this.getLotteryName().toString() : null), LotteryModel.class);
            }
            value = this.cache.get(this.parentKey, LotteryModelDomain.createCacheKey(this.getLotteryName() != null ? this.getLotteryName().toString() : null), LotteryModel.class);
        }
        return value;
    }
}

