/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.lottery.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.lottery.Gs2LotteryRestClient;
import io.gs2.lottery.domain.model.BoxDomain;
import io.gs2.lottery.domain.model.BoxItemsDomain;
import io.gs2.lottery.domain.model.UserDomain;
import io.gs2.lottery.model.Box;
import io.gs2.lottery.model.BoxItems;
import io.gs2.lottery.request.GetBoxRequest;
import io.gs2.lottery.request.ResetBoxRequest;
import io.gs2.lottery.result.GetBoxResult;
import io.gs2.lottery.result.ResetBoxResult;

public class BoxAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2LotteryRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String prizeTableName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getPrizeTableName() {
        return this.prizeTableName;
    }

    public BoxAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String prizeTableName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2LotteryRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.prizeTableName = prizeTableName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Box");
    }

    private BoxItems get(GetBoxRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withPrizeTableName(this.prizeTableName);
        GetBoxResult result = this.client.getBox(request);
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "BoxItems");
        if (result.getItem() != null) {
            this.cache.put(parentKey, BoxItemsDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public BoxAccessTokenDomain reset(ResetBoxRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withPrizeTableName(this.prizeTableName);
        ResetBoxResult result = this.client.resetBox(request);
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Box");
        for (Box item : this.cache.list(parentKey, Box.class)) {
            this.cache.delete(parentKey, BoxDomain.createCacheKey(request.getPrizeTableName() != null ? request.getPrizeTableName().toString() : null), Box.class);
        }
        BoxAccessTokenDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String prizeTableName, String childType) {
        return String.join((CharSequence)":", "lottery", namespaceName, userId, prizeTableName, childType);
    }

    public static String createCacheKey(String prizeTableName) {
        return String.join((CharSequence)":", prizeTableName);
    }

    public BoxItems model() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "BoxItems");
        BoxItems value = this.cache.get(parentKey, BoxItemsDomain.createCacheKey(), BoxItems.class);
        if (value == null) {
            try {
                this.get(new GetBoxRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(parentKey, BoxItemsDomain.createCacheKey(), BoxItems.class);
            }
            value = this.cache.get(parentKey, BoxItemsDomain.createCacheKey(), BoxItems.class);
        }
        return value;
    }
}

