/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.lottery.domain.iterator;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.lottery.Gs2LotteryRestClient;
import io.gs2.lottery.domain.model.BoxDomain;
import io.gs2.lottery.domain.model.UserDomain;
import io.gs2.lottery.model.Box;
import io.gs2.lottery.request.DescribeBoxesRequest;
import io.gs2.lottery.result.DescribeBoxesResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeBoxesIterator
implements Iterator<Box>,
Iterable<Box> {
    CacheDatabase cache;
    Gs2LotteryRestClient client;
    String namespaceName;
    AccessToken accessToken;
    String pageToken;
    boolean last;
    List<Box> result;
    Integer fetchSize;

    public DescribeBoxesIterator(CacheDatabase cache, Gs2LotteryRestClient client, String namespaceName, AccessToken accessToken) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Box>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Box");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Box.class)) {
            this.result = this.cache.list(parentKey, Box.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeBoxesResult r = this.client.describeBoxes(new DescribeBoxesRequest().withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Box item : this.result) {
                this.cache.put(parentKey, BoxDomain.createCacheKey(item.getPrizeTableName() != null ? item.getPrizeTableName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Box.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Box next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Box ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Box> iterator() {
        return this;
    }
}

