/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.lottery.domain;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.jobQueue.model.Job;
import io.gs2.jobQueue.model.JobResultBody;
import io.gs2.lottery.Gs2LotteryRestClient;
import io.gs2.lottery.domain.iterator.DescribeNamespacesIterator;
import io.gs2.lottery.domain.model.LotteryDomain;
import io.gs2.lottery.domain.model.NamespaceDomain;
import io.gs2.lottery.domain.model.UserDomain;
import io.gs2.lottery.model.DrawnPrize;
import io.gs2.lottery.request.CreateNamespaceRequest;
import io.gs2.lottery.request.DrawByUserIdRequest;
import io.gs2.lottery.result.CreateNamespaceResult;
import io.gs2.lottery.result.DrawByUserIdResult;

public class Gs2Lottery {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2LotteryRestClient client;
    private final String parentKey;

    public Gs2Lottery(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2LotteryRestClient(session);
        this.parentKey = "lottery";
    }

    public NamespaceDomain createNamespace(CreateNamespaceRequest request) {
        CreateNamespaceResult result = this.client.createNamespace(request);
        String parentKey = "lottery:Namespace";
        if (result.getItem() != null) {
            this.cache.put(parentKey, NamespaceDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        NamespaceDomain domain = new NamespaceDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, result.getItem().getName());
        return domain;
    }

    public DescribeNamespacesIterator namespaces() {
        return new DescribeNamespacesIterator(this.cache, this.client);
    }

    public NamespaceDomain namespace(String namespaceName) {
        return new NamespaceDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, namespaceName);
    }

    public static void updateCacheFromStampSheet(CacheDatabase cache, String method, String request, String result) {
        try {
            switch (method) {
                case "DrawByUserId": {
                    DrawByUserIdRequest requestModel = DrawByUserIdRequest.fromJson(new ObjectMapper().readTree(request));
                    DrawByUserIdResult resultModel = DrawByUserIdResult.fromJson(new ObjectMapper().readTree(result));
                    for (DrawnPrize item : resultModel.getItems()) {
                        String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), requestModel.getUserId().toString(), "Lottery");
                        String key = LotteryDomain.createCacheKey();
                        cache.put(parentKey, key, item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    }
                    break;
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static void updateCacheFromStampTask(CacheDatabase cache, String method, String request, String result) {
    }

    public static void updateCacheFromJobResult(CacheDatabase cache, String method, Job job, JobResultBody result) {
        try {
            switch (method) {
                case "draw_by_user_id": {
                    DrawByUserIdRequest requestModel = DrawByUserIdRequest.fromJson(new ObjectMapper().readTree(job.getArgs()));
                    DrawByUserIdResult resultModel = DrawByUserIdResult.fromJson(new ObjectMapper().readTree(result.getResult()));
                    for (DrawnPrize item : resultModel.getItems()) {
                        String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), requestModel.getUserId().toString(), "Lottery");
                        String key = LotteryDomain.createCacheKey();
                        cache.put(parentKey, key, item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    }
                    break;
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }
}

