/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.log.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.log.Gs2LogRestClient;
import io.gs2.log.domain.model.NamespaceDomain;
import io.gs2.log.model.IssueStampSheetLog;

public class IssueStampSheetLogDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2LogRestClient client;
    private final String namespaceName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public IssueStampSheetLogDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2LogRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "IssueStampSheetLog");
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "log", namespaceName, childType);
    }

    public static String createCacheKey() {
        return "Singleton";
    }

    public IssueStampSheetLog model() {
        IssueStampSheetLog value = this.cache.get(this.parentKey, IssueStampSheetLogDomain.createCacheKey(), IssueStampSheetLog.class);
        return value;
    }
}

