/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.log.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.log.Gs2LogRestClient;
import io.gs2.log.domain.model.NamespaceDomain;
import io.gs2.log.model.ExecuteStampTaskLogCount;

public class ExecuteStampTaskLogCountDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2LogRestClient client;
    private final String namespaceName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public ExecuteStampTaskLogCountDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2LogRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "ExecuteStampTaskLogCount");
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "log", namespaceName, childType);
    }

    public static String createCacheKey() {
        return "Singleton";
    }

    public ExecuteStampTaskLogCount model() {
        ExecuteStampTaskLogCount value = this.cache.get(this.parentKey, ExecuteStampTaskLogCountDomain.createCacheKey(), ExecuteStampTaskLogCount.class);
        return value;
    }
}

