/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.log.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.log.Gs2LogRestClient;
import io.gs2.log.domain.model.AccessLogDomain;
import io.gs2.log.domain.model.NamespaceDomain;
import io.gs2.log.model.AccessLog;
import io.gs2.log.request.QueryAccessLogRequest;
import io.gs2.log.result.QueryAccessLogResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class QueryAccessLogIterator
implements Iterator<AccessLog>,
Iterable<AccessLog> {
    CacheDatabase cache;
    Gs2LogRestClient client;
    String namespaceName;
    String service;
    String method;
    String userId;
    Long begin;
    Long end;
    Boolean longTerm;
    String pageToken;
    boolean last;
    List<AccessLog> result;
    Integer fetchSize;

    public QueryAccessLogIterator(CacheDatabase cache, Gs2LogRestClient client, String namespaceName, String service, String method, String userId, Long begin, Long end, Boolean longTerm) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.service = service;
        this.method = method;
        this.userId = userId;
        this.begin = begin;
        this.end = end;
        this.longTerm = longTerm;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<AccessLog>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "AccessLog");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, AccessLog.class)) {
            this.result = this.cache.list(parentKey, AccessLog.class).stream().filter(item -> this.service == null || item.getService().equals(this.service)).filter(item -> this.method == null || item.getMethod().equals(this.method)).filter(item -> this.userId == null || item.getUserId().equals(this.userId)).filter(item -> this.begin == null || item.getTimestamp() >= this.begin).filter(item -> this.end == null || item.getTimestamp() <= this.end).collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            QueryAccessLogResult r = this.client.queryAccessLog(new QueryAccessLogRequest().withNamespaceName(this.namespaceName).withService(this.service).withMethod(this.method).withUserId(this.userId).withBegin(this.begin).withEnd(this.end).withLongTerm(this.longTerm).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (AccessLog item2 : this.result) {
                this.cache.put(parentKey, AccessLogDomain.createCacheKey(), item2, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, AccessLog.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public AccessLog next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        AccessLog ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<AccessLog> iterator() {
        return this;
    }
}

