/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.log.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.log.Gs2LogRestClient;
import io.gs2.log.model.ExecuteStampTaskLogCount;
import io.gs2.log.request.CountExecuteStampTaskLogRequest;
import io.gs2.log.result.CountExecuteStampTaskLogResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CountExecuteStampTaskLogIterator
implements Iterator<ExecuteStampTaskLogCount>,
Iterable<ExecuteStampTaskLogCount> {
    CacheDatabase cache;
    Gs2LogRestClient client;
    String namespaceName;
    Boolean service;
    Boolean method;
    Boolean userId;
    Boolean action;
    Long begin;
    Long end;
    Boolean longTerm;
    String pageToken;
    boolean last;
    List<ExecuteStampTaskLogCount> result;
    Integer fetchSize;

    public CountExecuteStampTaskLogIterator(CacheDatabase cache, Gs2LogRestClient client, String namespaceName, Boolean service, Boolean method, Boolean userId, Boolean action, Long begin, Long end, Boolean longTerm) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.service = service;
        this.method = method;
        this.userId = userId;
        this.action = action;
        this.begin = begin;
        this.end = end;
        this.longTerm = longTerm;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<ExecuteStampTaskLogCount>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        CountExecuteStampTaskLogResult r = this.client.countExecuteStampTaskLog(new CountExecuteStampTaskLogRequest().withNamespaceName(this.namespaceName).withService(this.service).withMethod(this.method).withUserId(this.userId).withAction(this.action).withBegin(this.begin).withEnd(this.end).withLongTerm(this.longTerm).withPageToken(this.pageToken).withLimit(this.fetchSize));
        this.result = r.getItems();
        this.pageToken = r.getNextPageToken();
        this.last = this.pageToken == null;
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public ExecuteStampTaskLogCount next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        ExecuteStampTaskLogCount ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<ExecuteStampTaskLogCount> iterator() {
        return this;
    }
}

