/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.lock.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.lock.Gs2LockRestClient;
import io.gs2.lock.domain.model.MutexDomain;
import io.gs2.lock.domain.model.UserDomain;
import io.gs2.lock.model.Mutex;
import io.gs2.lock.request.GetMutexRequest;
import io.gs2.lock.request.LockRequest;
import io.gs2.lock.request.UnlockRequest;
import io.gs2.lock.result.GetMutexResult;
import io.gs2.lock.result.LockResult;
import io.gs2.lock.result.UnlockResult;

public class MutexAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2LockRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String propertyId;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public MutexAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String propertyId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2LockRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.propertyId = propertyId;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Mutex");
    }

    public MutexAccessTokenDomain lock(LockRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withPropertyId(this.propertyId);
        LockResult result = this.client.lock(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MutexDomain.createCacheKey(request.getPropertyId() != null ? request.getPropertyId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        MutexAccessTokenDomain domain = this;
        return domain;
    }

    public MutexAccessTokenDomain unlock(UnlockRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withPropertyId(this.propertyId);
        UnlockResult result = null;
        try {
            result = this.client.unlock(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, MutexDomain.createCacheKey(request.getPropertyId() != null ? request.getPropertyId().toString() : null), Mutex.class);
        MutexAccessTokenDomain domain = this;
        return domain;
    }

    private Mutex get(GetMutexRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withPropertyId(this.propertyId);
        GetMutexResult result = this.client.getMutex(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MutexDomain.createCacheKey(request.getPropertyId() != null ? request.getPropertyId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public static String createCacheParentKey(String namespaceName, String userId, String propertyId, String childType) {
        return String.join((CharSequence)":", "lock", namespaceName, userId, propertyId, childType);
    }

    public static String createCacheKey(String propertyId) {
        return String.join((CharSequence)":", propertyId);
    }

    public Mutex model() {
        Mutex value = this.cache.get(this.parentKey, MutexDomain.createCacheKey(this.getPropertyId() != null ? this.getPropertyId().toString() : null), Mutex.class);
        if (value == null) {
            try {
                this.get(new GetMutexRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, MutexDomain.createCacheKey(this.getPropertyId() != null ? this.getPropertyId().toString() : null), Mutex.class);
            }
            value = this.cache.get(this.parentKey, MutexDomain.createCacheKey(this.getPropertyId() != null ? this.getPropertyId().toString() : null), Mutex.class);
        }
        return value;
    }
}

