/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.limit.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.limit.Gs2LimitRestClient;
import io.gs2.limit.domain.model.NamespaceDomain;
import io.gs2.limit.model.LimitModelMaster;
import io.gs2.limit.request.DeleteLimitModelMasterRequest;
import io.gs2.limit.request.GetLimitModelMasterRequest;
import io.gs2.limit.request.UpdateLimitModelMasterRequest;
import io.gs2.limit.result.DeleteLimitModelMasterResult;
import io.gs2.limit.result.GetLimitModelMasterResult;
import io.gs2.limit.result.UpdateLimitModelMasterResult;

public class LimitModelMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2LimitRestClient client;
    private final String namespaceName;
    private final String limitName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getLimitName() {
        return this.limitName;
    }

    public LimitModelMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String limitName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2LimitRestClient(session);
        this.namespaceName = namespaceName;
        this.limitName = limitName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "LimitModelMaster");
    }

    private LimitModelMaster get(GetLimitModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withLimitName(this.limitName);
        GetLimitModelMasterResult result = this.client.getLimitModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, LimitModelMasterDomain.createCacheKey(request.getLimitName() != null ? request.getLimitName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public LimitModelMasterDomain update(UpdateLimitModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withLimitName(this.limitName);
        UpdateLimitModelMasterResult result = this.client.updateLimitModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, LimitModelMasterDomain.createCacheKey(request.getLimitName() != null ? request.getLimitName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        LimitModelMasterDomain domain = this;
        return domain;
    }

    public LimitModelMasterDomain delete(DeleteLimitModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withLimitName(this.limitName);
        DeleteLimitModelMasterResult result = null;
        try {
            result = this.client.deleteLimitModelMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, LimitModelMasterDomain.createCacheKey(request.getLimitName() != null ? request.getLimitName().toString() : null), LimitModelMaster.class);
        LimitModelMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String limitName, String childType) {
        return String.join((CharSequence)":", "limit", namespaceName, limitName, childType);
    }

    public static String createCacheKey(String limitName) {
        return String.join((CharSequence)":", limitName);
    }

    public LimitModelMaster model() {
        LimitModelMaster value = this.cache.get(this.parentKey, LimitModelMasterDomain.createCacheKey(this.getLimitName() != null ? this.getLimitName().toString() : null), LimitModelMaster.class);
        if (value == null) {
            try {
                this.get(new GetLimitModelMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, LimitModelMasterDomain.createCacheKey(this.getLimitName() != null ? this.getLimitName().toString() : null), LimitModelMaster.class);
            }
            value = this.cache.get(this.parentKey, LimitModelMasterDomain.createCacheKey(this.getLimitName() != null ? this.getLimitName().toString() : null), LimitModelMaster.class);
        }
        return value;
    }
}

