/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.limit.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.limit.Gs2LimitRestClient;
import io.gs2.limit.domain.model.NamespaceDomain;
import io.gs2.limit.model.LimitModel;
import io.gs2.limit.request.GetLimitModelRequest;
import io.gs2.limit.result.GetLimitModelResult;

public class LimitModelDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2LimitRestClient client;
    private final String namespaceName;
    private final String limitName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getLimitName() {
        return this.limitName;
    }

    public LimitModelDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String limitName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2LimitRestClient(session);
        this.namespaceName = namespaceName;
        this.limitName = limitName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "LimitModel");
    }

    private LimitModel get(GetLimitModelRequest request) {
        request.withNamespaceName(this.namespaceName).withLimitName(this.limitName);
        GetLimitModelResult result = this.client.getLimitModel(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, LimitModelDomain.createCacheKey(request.getLimitName() != null ? request.getLimitName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public static String createCacheParentKey(String namespaceName, String limitName, String childType) {
        return String.join((CharSequence)":", "limit", namespaceName, limitName, childType);
    }

    public static String createCacheKey(String limitName) {
        return String.join((CharSequence)":", limitName);
    }

    public LimitModel model() {
        LimitModel value = this.cache.get(this.parentKey, LimitModelDomain.createCacheKey(this.getLimitName() != null ? this.getLimitName().toString() : null), LimitModel.class);
        if (value == null) {
            try {
                this.get(new GetLimitModelRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, LimitModelDomain.createCacheKey(this.getLimitName() != null ? this.getLimitName().toString() : null), LimitModel.class);
            }
            value = this.cache.get(this.parentKey, LimitModelDomain.createCacheKey(this.getLimitName() != null ? this.getLimitName().toString() : null), LimitModel.class);
        }
        return value;
    }
}

