/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.limit.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.limit.Gs2LimitRestClient;
import io.gs2.limit.domain.model.NamespaceDomain;
import io.gs2.limit.model.CurrentLimitMaster;
import io.gs2.limit.request.ExportMasterRequest;
import io.gs2.limit.request.GetCurrentLimitMasterRequest;
import io.gs2.limit.request.UpdateCurrentLimitMasterFromGitHubRequest;
import io.gs2.limit.request.UpdateCurrentLimitMasterRequest;
import io.gs2.limit.result.ExportMasterResult;
import io.gs2.limit.result.GetCurrentLimitMasterResult;
import io.gs2.limit.result.UpdateCurrentLimitMasterFromGitHubResult;
import io.gs2.limit.result.UpdateCurrentLimitMasterResult;

public class CurrentLimitMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2LimitRestClient client;
    private final String namespaceName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public CurrentLimitMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2LimitRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CurrentLimitMaster");
    }

    public CurrentLimitMasterDomain exportMaster(ExportMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        ExportMasterResult result = this.client.exportMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentLimitMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentLimitMasterDomain domain = this;
        return domain;
    }

    private CurrentLimitMaster get(GetCurrentLimitMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetCurrentLimitMasterResult result = this.client.getCurrentLimitMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentLimitMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public CurrentLimitMasterDomain update(UpdateCurrentLimitMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentLimitMasterResult result = this.client.updateCurrentLimitMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentLimitMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentLimitMasterDomain domain = this;
        return domain;
    }

    public CurrentLimitMasterDomain updateFromGitHub(UpdateCurrentLimitMasterFromGitHubRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentLimitMasterFromGitHubResult result = this.client.updateCurrentLimitMasterFromGitHub(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentLimitMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentLimitMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "limit", namespaceName, childType);
    }

    public static String createCacheKey(String namespaceName) {
        return String.join((CharSequence)":", namespaceName);
    }

    public CurrentLimitMaster model() {
        CurrentLimitMaster value = this.cache.get(this.parentKey, CurrentLimitMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentLimitMaster.class);
        if (value == null) {
            try {
                this.get(new GetCurrentLimitMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CurrentLimitMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentLimitMaster.class);
            }
            value = this.cache.get(this.parentKey, CurrentLimitMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentLimitMaster.class);
        }
        return value;
    }
}

