/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.limit.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.limit.Gs2LimitRestClient;
import io.gs2.limit.domain.model.UserDomain;
import io.gs2.limit.model.Counter;
import io.gs2.limit.request.CountUpByUserIdRequest;
import io.gs2.limit.request.DeleteCounterByUserIdRequest;
import io.gs2.limit.request.GetCounterByUserIdRequest;
import io.gs2.limit.result.CountUpByUserIdResult;
import io.gs2.limit.result.DeleteCounterByUserIdResult;
import io.gs2.limit.result.GetCounterByUserIdResult;

public class CounterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2LimitRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String limitName;
    private final String counterName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getLimitName() {
        return this.limitName;
    }

    public String getCounterName() {
        return this.counterName;
    }

    public CounterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String limitName, String counterName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2LimitRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.limitName = limitName;
        this.counterName = counterName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Counter");
    }

    private Counter get(GetCounterByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withLimitName(this.limitName).withCounterName(this.counterName);
        GetCounterByUserIdResult result = this.client.getCounterByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CounterDomain.createCacheKey(request.getLimitName() != null ? request.getLimitName().toString() : null, request.getCounterName() != null ? request.getCounterName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public CounterDomain countUp(CountUpByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withLimitName(this.limitName).withCounterName(this.counterName);
        CountUpByUserIdResult result = this.client.countUpByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CounterDomain.createCacheKey(request.getLimitName() != null ? request.getLimitName().toString() : null, request.getCounterName() != null ? request.getCounterName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CounterDomain domain = this;
        return domain;
    }

    public CounterDomain delete(DeleteCounterByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withLimitName(this.limitName).withCounterName(this.counterName);
        DeleteCounterByUserIdResult result = null;
        try {
            result = this.client.deleteCounterByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, CounterDomain.createCacheKey(request.getLimitName() != null ? request.getLimitName().toString() : null, request.getCounterName() != null ? request.getCounterName().toString() : null), Counter.class);
        CounterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String limitName, String counterName, String childType) {
        return String.join((CharSequence)":", "limit", namespaceName, userId, limitName, counterName, childType);
    }

    public static String createCacheKey(String limitName, String counterName) {
        return String.join((CharSequence)":", limitName, counterName);
    }

    public Counter model() {
        Counter value = this.cache.get(this.parentKey, CounterDomain.createCacheKey(this.getLimitName() != null ? this.getLimitName().toString() : null, this.getCounterName() != null ? this.getCounterName().toString() : null), Counter.class);
        if (value == null) {
            try {
                this.get(new GetCounterByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CounterDomain.createCacheKey(this.getLimitName() != null ? this.getLimitName().toString() : null, this.getCounterName() != null ? this.getCounterName().toString() : null), Counter.class);
            }
            value = this.cache.get(this.parentKey, CounterDomain.createCacheKey(this.getLimitName() != null ? this.getLimitName().toString() : null, this.getCounterName() != null ? this.getCounterName().toString() : null), Counter.class);
        }
        return value;
    }
}

