/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.limit.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.limit.Gs2LimitRestClient;
import io.gs2.limit.domain.model.CounterDomain;
import io.gs2.limit.domain.model.UserDomain;
import io.gs2.limit.model.Counter;
import io.gs2.limit.request.CountUpRequest;
import io.gs2.limit.request.GetCounterRequest;
import io.gs2.limit.result.CountUpResult;
import io.gs2.limit.result.GetCounterResult;

public class CounterAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2LimitRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String limitName;
    private final String counterName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getLimitName() {
        return this.limitName;
    }

    public String getCounterName() {
        return this.counterName;
    }

    public CounterAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String limitName, String counterName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2LimitRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.limitName = limitName;
        this.counterName = counterName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Counter");
    }

    private Counter get(GetCounterRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withLimitName(this.limitName).withCounterName(this.counterName);
        GetCounterResult result = this.client.getCounter(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CounterDomain.createCacheKey(request.getLimitName() != null ? request.getLimitName().toString() : null, request.getCounterName() != null ? request.getCounterName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public CounterAccessTokenDomain countUp(CountUpRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withLimitName(this.limitName).withCounterName(this.counterName);
        CountUpResult result = this.client.countUp(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CounterDomain.createCacheKey(request.getLimitName() != null ? request.getLimitName().toString() : null, request.getCounterName() != null ? request.getCounterName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CounterAccessTokenDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String limitName, String counterName, String childType) {
        return String.join((CharSequence)":", "limit", namespaceName, userId, limitName, counterName, childType);
    }

    public static String createCacheKey(String limitName, String counterName) {
        return String.join((CharSequence)":", limitName, counterName);
    }

    public Counter model() {
        Counter value = this.cache.get(this.parentKey, CounterDomain.createCacheKey(this.getLimitName() != null ? this.getLimitName().toString() : null, this.getCounterName() != null ? this.getCounterName().toString() : null), Counter.class);
        if (value == null) {
            try {
                this.get(new GetCounterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CounterDomain.createCacheKey(this.getLimitName() != null ? this.getLimitName().toString() : null, this.getCounterName() != null ? this.getCounterName().toString() : null), Counter.class);
            }
            value = this.cache.get(this.parentKey, CounterDomain.createCacheKey(this.getLimitName() != null ? this.getLimitName().toString() : null, this.getCounterName() != null ? this.getCounterName().toString() : null), Counter.class);
        }
        return value;
    }
}

