/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.limit.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.limit.Gs2LimitRestClient;
import io.gs2.limit.domain.model.LimitModelMasterDomain;
import io.gs2.limit.domain.model.NamespaceDomain;
import io.gs2.limit.model.LimitModelMaster;
import io.gs2.limit.request.DescribeLimitModelMastersRequest;
import io.gs2.limit.result.DescribeLimitModelMastersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeLimitModelMastersIterator
implements Iterator<LimitModelMaster>,
Iterable<LimitModelMaster> {
    CacheDatabase cache;
    Gs2LimitRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<LimitModelMaster> result;
    Integer fetchSize;

    public DescribeLimitModelMastersIterator(CacheDatabase cache, Gs2LimitRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<LimitModelMaster>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "LimitModelMaster");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, LimitModelMaster.class)) {
            this.result = this.cache.list(parentKey, LimitModelMaster.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeLimitModelMastersResult r = this.client.describeLimitModelMasters(new DescribeLimitModelMastersRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (LimitModelMaster item : this.result) {
                this.cache.put(parentKey, LimitModelMasterDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, LimitModelMaster.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public LimitModelMaster next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        LimitModelMaster ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<LimitModelMaster> iterator() {
        return this;
    }
}

