/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.key.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.key.Gs2KeyRestClient;
import io.gs2.key.domain.model.NamespaceDomain;
import io.gs2.key.model.Key;
import io.gs2.key.request.DecryptRequest;
import io.gs2.key.request.DeleteKeyRequest;
import io.gs2.key.request.EncryptRequest;
import io.gs2.key.request.GetKeyRequest;
import io.gs2.key.request.UpdateKeyRequest;
import io.gs2.key.result.DecryptResult;
import io.gs2.key.result.DeleteKeyResult;
import io.gs2.key.result.EncryptResult;
import io.gs2.key.result.GetKeyResult;
import io.gs2.key.result.UpdateKeyResult;

public class KeyDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2KeyRestClient client;
    private final String namespaceName;
    private final String keyName;
    private final String parentKey;
    String data;

    public String getData() {
        return this.data;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public KeyDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String keyName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2KeyRestClient(session);
        this.namespaceName = namespaceName;
        this.keyName = keyName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Key");
    }

    public KeyDomain update(UpdateKeyRequest request) {
        request.withNamespaceName(this.namespaceName).withKeyName(this.keyName);
        UpdateKeyResult result = this.client.updateKey(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, KeyDomain.createCacheKey(request.getKeyName() != null ? request.getKeyName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        KeyDomain domain = this;
        return domain;
    }

    private Key get(GetKeyRequest request) {
        request.withNamespaceName(this.namespaceName).withKeyName(this.keyName);
        GetKeyResult result = this.client.getKey(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, KeyDomain.createCacheKey(request.getKeyName() != null ? request.getKeyName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public KeyDomain delete(DeleteKeyRequest request) {
        request.withNamespaceName(this.namespaceName).withKeyName(this.keyName);
        DeleteKeyResult result = null;
        try {
            result = this.client.deleteKey(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, KeyDomain.createCacheKey(request.getKeyName() != null ? request.getKeyName().toString() : null), Key.class);
        KeyDomain domain = this;
        return domain;
    }

    public KeyDomain encrypt(EncryptRequest request) {
        request.withNamespaceName(this.namespaceName).withKeyName(this.keyName);
        EncryptResult result = this.client.encrypt(request);
        KeyDomain domain = this;
        this.data = result.getData();
        return domain;
    }

    public KeyDomain decrypt(DecryptRequest request) {
        request.withNamespaceName(this.namespaceName).withKeyName(this.keyName);
        DecryptResult result = this.client.decrypt(request);
        KeyDomain domain = this;
        this.data = result.getData();
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String keyName, String childType) {
        return String.join((CharSequence)":", "key", namespaceName, keyName, childType);
    }

    public static String createCacheKey(String keyName) {
        return String.join((CharSequence)":", keyName);
    }

    public Key model() {
        Key value = this.cache.get(this.parentKey, KeyDomain.createCacheKey(this.getKeyName() != null ? this.getKeyName().toString() : null), Key.class);
        if (value == null) {
            try {
                this.get(new GetKeyRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, KeyDomain.createCacheKey(this.getKeyName() != null ? this.getKeyName().toString() : null), Key.class);
            }
            value = this.cache.get(this.parentKey, KeyDomain.createCacheKey(this.getKeyName() != null ? this.getKeyName().toString() : null), Key.class);
        }
        return value;
    }
}

